/**
 * ##% Copyright (C) 2008 Code Lutin, Tony Chemit
 * This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. This program is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details. You
 * should have received a copy of the GNU General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 59 Temple Place
 * - Suite 330, Boston, MA 02111-1307, USA. 
 * ##%
 */
package org.nuiton.jaxx.action;

import static org.nuiton.i18n.I18n._;

import javax.swing.AbstractButton;
import javax.swing.Action;

/**
 * Implementation of configuration's resolver for annotation {@link ActionConfig}
 *
 * @author chemit
 */
public class ActionConfigConfigurationResolver extends AbstractActionConfigurationResolver<ActionConfig, AbstractButton> {

    public ActionConfigConfigurationResolver() {
        super(ActionConfig.class, AbstractButton.class);
    }

    @Override
    protected ActionConfig applyConfiguration0(AbstractButton component, MyAbstractAction action) {
        ActionConfig anno = resolveConfiguration(action);
        if (anno == null) {
            return null;
        }
        // inject les données
        if (!anno.name().isEmpty()) {
            //System.out.println("found action with name : " + anno.name());
            action.putValue(Action.NAME, _(anno.name()));
        }
        //if (!anno.shortDescription().isEmpty()) {
        action.putValue(Action.SHORT_DESCRIPTION, _(anno.shortDescription()));
        //}
        if (!anno.smallIcon().isEmpty()) {
            action.putValue(Action.SMALL_ICON, org.nuiton.jaxx.util.UIHelper.createImageIcon(anno.smallIcon()));
        }
        if (anno.mnemonic() != '\0') {
            action.putValue(Action.MNEMONIC_KEY, anno.mnemonic());
        } else if (component != null) {
            action.putValue(Action.MNEMONIC_KEY, component.getMnemonic());
        }
        //TODO Convert it from String action.putValue(Action.ACCELERATOR_KEY, anno.accelerator());

        if (component == null) {
            action.putValue("hideActionText", anno.hideActionText());
        } else {
            boolean actionText = component.getHideActionText();
            action.putValue("hideActionText", anno.hideActionText() || actionText);
        }
        action.putValue(Action.SELECTED_KEY, anno.selected());
        action.setEnabled(anno.enabled());

        return anno;
    }
}
