/* 
* ##% Copyright (C) 2002, 2003, 2004, 2005, 2006, 2007, 2008 Code Lutin,
* Tony Chemit, Gabriel Landais
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
* ##% */
package org.nuiton.jaxx.action;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Pour enregister une action.
 * <p/>
 * Placer cette annotation sur la classe implantant l'action,
 * <p/>
 * les informations décrites seront utilisées pour instancier l'action
 *
 * @author chemit
 */
@Retention(RetentionPolicy.RUNTIME)

@Target(ElementType.TYPE)
@Inherited
public @interface ActionConfig {

    /**
     * @return la clef de la commande (doit être unique)
     * @see javax.swing.Action#ACTION_COMMAND_KEY
     */
    String actionCommand();

    /** @return array of names to be used in actions mapping */
    String[] actionCommands() default {};

    /**
     * @return the class to obtain at runtime the array of names to be used in actions mapping.
     *         <p/>
     *         <b>Note : the special value {@link org.nuiton.jaxx.action.ActionNameProvider} is used to says not to used
     *         œthis mecanism since we can not set a null value in a annotation</b>
     */
    Class<? extends ActionNameProvider> actionCommandProvider() default org.nuiton.jaxx.action.ActionNameProvider.class;

    /**
     * @return la clef i18n du texte de l'action, si vide ignoré
     * @see javax.swing.Action#NAME
     */
    String name() default "";

    /**
     * @return la clef i18n du tooltip de l'action, si vide ignoré
     * @see javax.swing.Action#SHORT_DESCRIPTION
     */
    String shortDescription() default "";

    /**
     * @return la clef i18n du texte de l'action, si vide ignoré
     * @see javax.swing.Action#LONG_DESCRIPTION
     */
    String longDescription() default "";

    /**
     * @return le nom de l'icone associé, si vide ignoré
     * @see javax.swing.Action#SMALL_ICON
     */
    String smallIcon() default "";

    /**
     * @return le nom du grande icone associé, si vide ignoré
     * @see javax.swing.Action#LARGE_ICON_KEY
     */
    String largeIcon() default "";

    /**
     * @return accelerator
     * @see javax.swing.Action#ACCELERATOR_KEY
     */
    String accelerator() default "";

    /**
     * @return mnemonic key
     * @see javax.swing.Action#MNEMONIC_KEY
     */
    int mnemonic() default '\0';

    /**
     * @return mnemonic key index
     * @see javax.swing.Action#DISPLAYED_MNEMONIC_INDEX_KEY
     */
    int displayedMnemonicIndex() default '\0';

    /**
     * @return la valeur par défaut pour les component selectable
     * @see javax.swing.Action#SELECTED_KEY
     */
    boolean selected() default false;

    /**
     * @return enabled state
     * @see javax.swing.Action#isEnabled()
     */
    boolean enabled() default true;

    /** @return hideActionText state */
    boolean hideActionText() default false;

}