/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NavigationTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(NavigationTreeModel.class);
    protected final String pathSeparator;
    private JAXXContext context;

    public NavigationTreeModel(String pathSeparator, JAXXContext context) {
        super(null);
        this.pathSeparator = pathSeparator;
        this.context = context;
    }

    @Override
    public NavigationTreeNode getRoot() {
        return (NavigationTreeNode)super.getRoot();
    }

    public NavigationTreeNode findNode(String path) {
        return this.findNode(this.getRoot(), path, (Pattern)null);
    }

    public NavigationTreeNode findNode(String path, String regex) {
        return this.findNode(this.getRoot(), path, regex);
    }

    public NavigationTreeNode findNode(String path, Pattern regex) {
        return this.findNode(this.getRoot(), path, regex);
    }

    public NavigationTreeNode findNode(NavigationTreeNode root, String path) {
        return this.findNode(root, path, (Pattern)null);
    }

    public NavigationTreeNode findNode(NavigationTreeNode root, String path, String regex) {
        return this.findNode(root, path, regex == null ? null : Pattern.compile(regex));
    }

    public NavigationTreeNode findNode(NavigationTreeNode root, String path, Pattern regex) {
        String rootPath;
        if (regex != null) {
            Matcher matcher = regex.matcher(path);
            if (!matcher.matches() || matcher.groupCount() < 1) {
                log.warn((Object)("no matching regex " + regex + " to " + path));
                return null;
            }
            path = matcher.group(1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("matching regex " + regex + " : " + path));
            }
        }
        StringTokenizer stk = new StringTokenizer(path, this.pathSeparator);
        NavigationTreeNode result = root;
        if (root.isRoot() && stk.hasMoreTokens() && !(rootPath = stk.nextToken()).equals(root.getNodePath())) {
            return null;
        }
        while (stk.hasMoreTokens()) {
            result = result.getChild(stk.nextToken());
        }
        return result;
    }

    public JAXXContext getContext() {
        return this.context;
    }

    public Object getBean(String navigationPath) {
        NavigationTreeNode node = this.findNode(navigationPath, (Pattern)null);
        Object result = this.getBean(node);
        return result;
    }

    public Object getBean(NavigationTreeNode node) {
        if (node == null) {
            return null;
        }
        return node.getBean(this.getContext());
    }

    @Override
    public void nodeChanged(TreeNode node) {
        this.nodeChanged(node, false);
        if (log.isDebugEnabled()) {
            log.debug((Object)node);
        }
    }

    @Override
    public void nodeStructureChanged(TreeNode node) {
        NavigationTreeNode n = (NavigationTreeNode)node;
        this.reload(n, true);
        super.nodeStructureChanged(node);
        if (log.isDebugEnabled()) {
            log.debug((Object)node);
        }
    }

    public void nodeChanged(TreeNode node, boolean deep) {
        NavigationTreeNode n = (NavigationTreeNode)node;
        this.reload(n, deep);
        super.nodeChanged(node);
    }

    protected void reload(NavigationTreeNode node) {
        this.reload(node, false);
    }

    protected void reload(NavigationTreeNode node, boolean deep) {
        if (node == null) {
            return;
        }
        node.reload(this.getContext());
        if (deep) {
            Enumeration<TreeNode> childs = node.children();
            while (childs.hasMoreElements()) {
                NavigationTreeNode o = (NavigationTreeNode)childs.nextElement();
                this.reload(o, true);
            }
        }
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }
}

