/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.java;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.java.JavaArgument;
import org.nuiton.jaxx.compiler.java.JavaConstructor;
import org.nuiton.jaxx.compiler.java.JavaElement;
import org.nuiton.jaxx.compiler.java.JavaField;
import org.nuiton.jaxx.compiler.java.JavaFile;
import org.nuiton.jaxx.compiler.java.JavaMethod;

public class JavaFileGenerator {
    private static final Log log = LogFactory.getLog(JavaFileGenerator.class);
    protected final String eol;
    protected final boolean verbose;
    protected int indentationLevel;

    public static String getHeader(String header) {
        String all = "/*-----------------------------------------------------------------------*/";
        int size = header.length();
        if (size % 2 == 0) {
            ++size;
            header = header + " ";
        }
        int semi = (all.length() - size) / 2 - 5;
        char[] prefix = new char[semi];
        Arrays.fill(prefix, '-');
        String eol = JAXXCompiler.getLineSeparator();
        return all + eol + "/*--" + new String(prefix) + " " + header + " " + new String(prefix) + "--*/" + eol + all + eol;
    }

    public JavaFileGenerator(String eol, boolean verbose) {
        this.eol = eol;
        this.verbose = verbose && log.isDebugEnabled();
    }

    public static String addDebugLoggerInvocation(JAXXCompiler compiler, String call) {
        String eol = JAXXCompiler.getLineSeparator();
        StringBuilder builder = new StringBuilder();
        if (!compiler.getConfiguration().isAddLogger()) {
            return "";
        }
        builder.append("if (log.isDebugEnabled()) {");
        builder.append(eol);
        builder.append("    log.debug(").append(call).append(");");
        builder.append(eol);
        builder.append("}");
        builder.append(eol);
        return builder.toString();
    }

    public String generateImport(String anImport) {
        return "import " + anImport + ';' + this.eol;
    }

    public void generateFile(JavaFile f, PrintWriter result) {
        String name = f.getName();
        if (this.verbose) {
            log.info((Object)name);
        }
        this.indentationLevel = 0;
        String packageName = f.getPackageName();
        if (packageName != null) {
            result.append("package ");
            result.append(packageName);
            result.append(";");
            result.append(this.eol).append(this.eol);
        }
        this.generateImports(f, result);
        result.append(this.generateClass(f));
    }

    public void generateImports(JavaFile f, PrintWriter result) {
        List<String> imports = f.getImportsList();
        boolean addImports = CollectionUtils.isNotEmpty(imports);
        for (String anImport : imports) {
            result.append(this.generateImport(anImport));
        }
        if (addImports) {
            result.append(this.eol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateClass(JavaFile f) {
        String txt;
        StringBuilder rawBodyCode;
        List<String> interfaces;
        if (this.verbose) {
            log.info((Object)f.getName());
        }
        StringBuilder result = new StringBuilder();
        String genericType = f.getGenericType();
        result.append(f.getModifiersText());
        if (f.isAbstractClass()) {
            result.append("abstract ");
        }
        result.append("class ");
        result.append(f.getName().substring(f.getName().lastIndexOf(".") + 1));
        if (genericType != null) {
            result.append('<').append(genericType).append('>');
        }
        result.append(" extends ");
        result.append(f.getSuperClass());
        if (f.getSuperGenericType() != null) {
            result.append('<').append(f.getSuperGenericType()).append('>');
        }
        if ((interfaces = f.getInterfaces()) != null && !interfaces.isEmpty()) {
            result.append(" implements ").append(interfaces.get(0));
            for (int i = 1; i < interfaces.size(); ++i) {
                result.append(", ").append(interfaces.get(i));
            }
        }
        result.append(" {").append(this.eol);
        List<JavaField> fields = f.getFields();
        if (!fields.isEmpty()) {
            EnumMap<JavaField.FieldOrder, List<JavaField>> map = JavaField.getSortedFields(fields);
            for (Map.Entry<JavaField.FieldOrder, List<JavaField>> entry : map.entrySet()) {
                List<JavaField> list = entry.getValue();
                Collections.sort(list);
                if (!list.isEmpty()) {
                    result.append(this.eol);
                    result.append(this.addIndentation(entry.getKey().getHeader(), 4, this.eol));
                    result.append(this.eol);
                    result.append(this.eol);
                    for (JavaField method : list) {
                        String txt2 = this.generateField(method);
                        result.append(this.addIndentation(txt2, 4, this.eol)).append(this.eol);
                    }
                }
                list.clear();
            }
            map.clear();
            result.append(this.eol);
        }
        if ((rawBodyCode = f.getRawBodyCode()).length() > 0) {
            result.append(this.addIndentation(JavaFileGenerator.getHeader("Raw body code from script"), 4, this.eol));
            result.append(this.eol);
            String s = rawBodyCode.toString();
            if (!s.startsWith(this.eol)) {
                result.append(this.eol);
            }
            result.append(this.addIndentation(s, 4, this.eol)).append(this.eol).append(this.eol);
        }
        List<JavaFile> innerClasses = f.getInnerClasses();
        for (JavaFile innerClass : innerClasses) {
            this.indentationLevel += 4;
            try {
                txt = this.generateClass(innerClass);
                result.append(this.addIndentation(txt, 4, this.eol));
                result.append(this.eol);
                result.append(this.eol);
            }
            finally {
                this.indentationLevel -= 4;
            }
        }
        result.append(this.addIndentation(JavaMethod.MethodOrder.constructors.getHeader(), 4, this.eol));
        result.append(this.eol);
        result.append(this.eol);
        for (JavaConstructor method : f.getConstructors()) {
            txt = this.generateConstructor(method);
            result.append(this.addIndentation(txt, 4, this.eol));
            result.append(this.eol);
            result.append(this.eol);
        }
        EnumMap<JavaMethod.MethodOrder, List<JavaMethod>> enumMap = JavaMethod.getSortedMethods(f.getMethods());
        for (Map.Entry<JavaMethod.MethodOrder, List<JavaMethod>> entry : enumMap.entrySet()) {
            List<JavaMethod> list = entry.getValue();
            if (!list.isEmpty()) {
                Collections.sort(list);
                result.append(this.addIndentation(entry.getKey().getHeader(), 4, this.eol));
                result.append(this.eol);
                result.append(this.eol);
                for (JavaMethod method : list) {
                    String txt3 = this.generateMethod(method);
                    result.append(this.addIndentation(txt3, 4, this.eol));
                    result.append(this.eol);
                    result.append(this.eol);
                }
            }
            list.clear();
        }
        enumMap.clear();
        result.append("}");
        return result.toString();
    }

    public String generateField(JavaField f) {
        if (this.verbose && log.isDebugEnabled()) {
            log.debug((Object)f.getName());
        }
        StringBuilder result = new StringBuilder();
        this.generateAnnotations(f, result, this.eol);
        result.append(f.getModifiersText());
        result.append(f.getType()).append(' ').append(f.getName());
        if (f.getInitializer() != null) {
            result.append(" = ").append(f.getInitializer());
        }
        result.append(';').append(this.eol);
        return result.toString();
    }

    protected void generateAnnotations(JavaElement element, StringBuilder result, String separator) {
        if (element.hasAnnotations()) {
            for (String annotation : element.getAnnotations()) {
                if (!annotation.startsWith("@")) {
                    result.append("@");
                }
                result.append(annotation).append(separator);
            }
        }
    }

    public String generateConstructor(JavaConstructor m) {
        String formattedBodyCode;
        if (this.verbose) {
            log.info((Object)m.getName());
        }
        StringBuilder result = new StringBuilder();
        this.generateAnnotations(m, result, this.eol);
        result.append(m.getModifiersText());
        result.append(m.getName());
        result.append('(');
        JavaArgument[] arguments = m.getArguments();
        if (arguments != null && arguments.length > 0) {
            result.append(this.generateArgument(arguments[0]));
            for (int i = 1; i < arguments.length; ++i) {
                result.append(", ").append(this.generateArgument(arguments[i]));
            }
        }
        result.append(")");
        String[] exceptions = m.getExceptions();
        if (exceptions != null && exceptions.length > 0) {
            result.append(" throws ").append(exceptions[0]);
            for (int i = 1; i < exceptions.length; ++i) {
                result.append(", ").append(exceptions[i]);
            }
        }
        result.append(" {");
        result.append(this.eol);
        String body = m.getBody();
        if (body != null && (formattedBodyCode = this.addIndentation(body.trim(), 4, this.eol)).length() > 0) {
            result.append(formattedBodyCode).append(this.eol);
        }
        result.append("}");
        return result.toString();
    }

    public String generateMethod(JavaMethod m) {
        String formattedBodyCode;
        if (this.verbose) {
            log.info((Object)m.getName());
        }
        StringBuilder result = new StringBuilder();
        if (m.isOverride()) {
            m.addAnnotation(Override.class.getSimpleName());
        }
        this.generateAnnotations(m, result, this.eol);
        result.append(m.getModifiersText());
        if (m.getReturnType() != null) {
            result.append(m.getReturnType());
            result.append(' ');
        }
        result.append(m.getName());
        result.append('(');
        JavaArgument[] arguments = m.getArguments();
        if (arguments != null && arguments.length > 0) {
            result.append(this.generateArgument(arguments[0]));
            for (int i = 1; i < arguments.length; ++i) {
                result.append(", ").append(this.generateArgument(arguments[i]));
            }
        }
        result.append(")");
        String[] exceptions = m.getExceptions();
        if (exceptions != null && exceptions.length > 0) {
            result.append(" throws ").append(exceptions[0]);
            for (int i = 1; i < exceptions.length; ++i) {
                result.append(", ").append(exceptions[i]);
            }
        }
        result.append(" {");
        result.append(this.eol);
        String body = m.getBody();
        if (body != null && (formattedBodyCode = this.addIndentation(body.trim(), 4, this.eol)).length() > 0) {
            result.append(formattedBodyCode).append(this.eol);
        }
        result.append("}");
        return result.toString();
    }

    public String generateArgument(JavaArgument argument) {
        String result = argument.getType() + ' ' + argument.getName();
        return argument.isFinal() ? "final " + result : result;
    }

    public String addIndentation(String source, int indentation, String lineSeparator) {
        return JavaFileGenerator.indent(source, this.indentationLevel + indentation, false, lineSeparator);
    }

    public static String indent(String source, int indentation, boolean trim, String lineSeparator) {
        if (trim) {
            source = source.trim();
        }
        char[] spaces = new char[indentation];
        Arrays.fill(spaces, ' ');
        StringBuilder result = new StringBuilder();
        String[] lines = source.split(lineSeparator + "|\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                result.append(lineSeparator);
            }
            result.append(spaces);
            result.append(trim ? lines[i].trim() : lines[i]);
        }
        return result.toString();
    }
}

