/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.application.swing.tab;

import java.awt.Component;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JTabbedPane;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.tab.CustomTab;
import org.nuiton.jaxx.application.swing.tab.TabContainerHandler;
import org.nuiton.jaxx.application.swing.tab.TabContentModel;
import org.nuiton.jaxx.application.swing.tab.TabHandler;

public class DelegateTabContainerHandler
implements TabContainerHandler {
    final JTabbedPane tabbedPane;

    public DelegateTabContainerHandler(JTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
    }

    @Override
    public JTabbedPane getTabPanel() {
        return this.tabbedPane;
    }

    @Override
    public void init() {
        this.getTabPanel().setModel(new DefaultSingleSelectionModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setSelectedIndex(int index) {
                int currentIndex = DelegateTabContainerHandler.this.getTabPanel().getSelectedIndex();
                boolean mustChangeTab = DelegateTabContainerHandler.this.onTabChanged(currentIndex, index);
                if (mustChangeTab) {
                    super.setSelectedIndex(index);
                }
            }
        });
    }

    @Override
    public boolean onTabChanged(int currentIndex, int newIndex) {
        boolean result = true;
        if (currentIndex != newIndex) {
            TabHandler handler = this.getTabHandler(currentIndex);
            if (handler != null) {
                result = handler.onHideTab(currentIndex, newIndex);
            }
            if ((handler = this.getTabHandler(newIndex)) != null) {
                handler.onShowTab(currentIndex, newIndex);
            }
        }
        return result;
    }

    @Override
    public TabHandler getTabHandler(int index) {
        ApplicationUI tuttiTab;
        Object handler;
        Component tab;
        TabHandler tabHandler = null;
        JTabbedPane tabPanel = this.getTabPanel();
        if (index >= 0 && index < tabPanel.getTabCount() && ApplicationUI.class.isInstance(tab = tabPanel.getComponentAt(index)) && TabHandler.class.isInstance(handler = (tuttiTab = (ApplicationUI)((Object)tabPanel.getComponentAt(index))).getHandler())) {
            tabHandler = (TabHandler)handler;
        }
        return tabHandler;
    }

    @Override
    public void setCustomTab(int index, TabContentModel model) {
        JTabbedPane tabPanel = this.getTabPanel();
        tabPanel.setTabComponentAt(index, new CustomTab(model, this));
    }

    @Override
    public boolean removeTab(int i) {
        TabHandler tabHandler = this.getTabHandler(i);
        boolean remove = tabHandler.onRemoveTab();
        if (remove) {
            this.getTabPanel().removeTabAt(i);
        }
        return remove;
    }
}

