/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.io.rest;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.nuiton.io.rest.RequestFactory;
import org.nuiton.io.rest.RestMethod;
import org.nuiton.io.rest.RestRequest;
import org.nuiton.io.rest.RestRequestBuilder;

public abstract class AbstractRequestFactory
implements RequestFactory {
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    protected final Map<String, RestRequestBuilder> requestBuilders = Maps.newTreeMap();

    @Override
    public void addRequestBuilder(RestRequestBuilder builder) {
        String name = builder.getName();
        if (this.requestBuilders.containsKey(name)) {
            throw new IllegalArgumentException("a request builder with name " + name + " already exists.");
        }
        this.requestBuilders.put(name, builder);
    }

    @Override
    public RestRequest getRequest(String id, Object ... args) {
        RestRequestBuilder builder = this.getRequestBuilder(id);
        if (builder == null) {
            throw new IllegalArgumentException("Could not find any request builder for request named '" + id + "'");
        }
        RestRequest r = builder.create(args);
        if (r == null) {
            throw new IllegalArgumentException("Could not find any request named '" + id + "' using builder " + builder);
        }
        return r;
    }

    @Override
    public RestRequestBuilder getRequestBuilder(String id) {
        RestRequestBuilder builder = this.requestBuilders.get(id);
        return builder;
    }

    protected static abstract class AbstractRequestBuilder
    implements RestRequestBuilder {
        private static final long serialVersionUID = 1L;
        protected String name;
        protected String[] action;
        protected final RestMethod method;

        public AbstractRequestBuilder(String name, RestMethod method, String ... action) {
            this.name = name;
            this.action = action;
            this.method = method;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getParameters(Object ... args) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }

        @Override
        public String[] getPath(Object ... args) {
            return this.action;
        }

        @Override
        public Map<String, File> getAttachments(Object ... args) {
            return null;
        }

        @Override
        public RestRequest create(final Object ... args) {
            this.checkRequestArgs(args);
            return new RestRequest(){

                @Override
                public String[] getPath() {
                    return AbstractRequestBuilder.this.getPath(args);
                }

                @Override
                public String[] getParameters() {
                    return AbstractRequestBuilder.this.getParameters(args);
                }

                @Override
                public Map<String, File> getAttachments() {
                    return AbstractRequestBuilder.this.getAttachments(args);
                }

                @Override
                public boolean containsAttachments() {
                    Map<String, File> attachments = this.getAttachments();
                    return attachments != null && !attachments.isEmpty();
                }

                @Override
                public String toPath(String redmineUrl) {
                    String result = redmineUrl + "/" + Joiner.on((char)'/').join((Object[])this.getPath());
                    return result;
                }

                @Override
                public RestMethod getMethod() {
                    return AbstractRequestBuilder.this.method;
                }
            };
        }

        protected void checkRequestArgs(int nbRequires, String requires, Object ... args) {
            Preconditions.checkState((args.length == nbRequires ? 1 : 0) != 0, (Object)(nbRequires == 0 ? "The request " + this.getName() + " requires no arg " + "but had: " + Arrays.toString(args) : "The request " + this.getName() + " requires " + nbRequires + " args: " + "(" + requires + "), but had: " + Arrays.toString(args)));
        }
    }
}

