package org.nuiton.eugene.plugin.modelextension;

/*-
 * #%L
 * EUGene :: Maven plugin
 * %%
 * Copyright (C) 2006 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Set;
import java.util.TreeSet;

/**
 * Created on 10/09/16.
 *
 * @author Tony Chemit - chemit@codelutin.com
 */
public class ModelBean extends ElementBean {

    protected final Set<PackageBean> packages;
    protected final Set<ClassBean> classes;

    public ModelBean(String name) {
        super(name);
        this.packages = new TreeSet<>();
        this.classes = new TreeSet<>();
    }

    public Set<PackageBean> getPackages() {
        return packages;
    }

    public Set<ClassBean> getClasses() {
        return classes;
    }

    public PackageBean getOrCreatePackage(final String packageName) {

        PackageBean result = null;
        for (PackageBean packageBean : packages) {
            if (packageName.equals(packageBean.name)) {
                result = packageBean;
                break;
            }
        }
        if (result == null) {
            result = new PackageBean(packageName);
            packages.add(result);
        }
        return result;
    }

    public ClassBean getOrCreateClass(final String className) {

        ClassBean result = null;
        for (ClassBean packageBean : classes) {
            if (className.equals(packageBean.name)) {
                result = packageBean;
                break;
            }
        }
        if (result == null) {
            result = new ClassBean(className);
            classes.add(result);
        }
        return result;
    }

    public AttributeBean getOrCreateClassAttribute(String className, String attributeName) {
        ClassBean classBean = getOrCreateClass(className);
        return classBean.getOrCreateAttribute(attributeName);
    }

    public boolean withClasses() {
        return !classes.isEmpty();
    }

    public boolean withPackages() {
        return !packages.isEmpty();
    }
}
