package org.nuiton.eugene.java;

/*
 * #%L
 * EUGene :: Java templates
 * $Id: SimpleJavaBeanTransformer.java 1216 2012-12-10 00:29:12Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/eugene/tags/eugene-2.6.1/eugene-java-templates/src/main/java/org/nuiton/eugene/java/SimpleJavaBeanTransformer.java $
 * %%
 * Copyright (C) 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */





import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorException;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * SimpleJavaBeanTransformer generates simple bean with pcs support
 * (and nothing else) according to the JavaBeans 1.1 norm with no Impl generation mecanism.
 * <p/>
 * So if there is so operation described on model, you should use the
 * {@link JavaBeanTransformer} instead.
 *
 * @author tchemit <chemit@codelutin.com>
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.eugene.java.SimpleJavaBeanTransformer"
 * @since 2.6
 */
public class SimpleJavaBeanTransformer extends AbstractJavaBeanTransformer {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(SimpleJavaBeanTransformer.class);

    @Override
    public void transformFromClass(ObjectModelClass input) {

        if (!JavaTemplatesGeneratorUtil.hasBeanStereotype(input)) {

            //  not a bean
            return;
        }


        if (canGenerate(input)) {

            ObjectModelClass output = generateBean(input);
        }

    }

    protected boolean canGenerate(ObjectModelClass input) {
        boolean canGenerate = !isInClassPath(input);

        if (canGenerate) {

            // check there is no operation on input
            if (!input.getOperations().isEmpty()) {

                throw new GeneratorException(
                        "Can't generate a simple bean as class " +
                        input.getQualifiedName() +
                        " contains so operations." +
                        "\nUse instead the JavaBeanTransformer.");
            }
        }
        return canGenerate;
    }

    protected ObjectModelClass generateBean(ObjectModelClass input) {

        // test if a super class has bean stereotype
        boolean superClassIsBean = false;
        Collection<ObjectModelClass> superclasses = input.getSuperclasses();
        if (CollectionUtils.isNotEmpty(superclasses)) {
            for (ObjectModelClass superclass : superclasses) {
                if (JavaTemplatesGeneratorUtil.hasBeanStereotype(superclass)) {
                    superClassIsBean = true;
                    break;
                }
            }
        }

        String superClass = null;

        if (!superClassIsBean) {

            // try to find a super class by tag-value
            superClass =
                    JavaTemplatesGeneratorUtil.getBeanSuperClassTagValue(
                            model, input);
            if (superClass != null) {

                // will act as if super class is a bean
                superClassIsBean = true;
            }
        }

        ObjectModelClass output =
                createClass(input.getName(), input.getPackageName());

        if (superClass != null) {
            setSuperClass(output, superClass);
        }
        if (log.isDebugEnabled()) {
            log.debug("will generate " + output.getQualifiedName());
        }

        String i18nPrefix = JavaGeneratorUtil.getI18nPrefixTagValue(input, model);
        if (!StringUtils.isEmpty(i18nPrefix)) {
            generateI18nBlock(input, output, i18nPrefix);
        }

        String noPCSTagValue = JavaTemplatesGeneratorUtil.getNoPCSTagValue(model, input);
        boolean usePCS = StringUtils.isEmpty(noPCSTagValue) ||
                         !"true".equals(noPCSTagValue.trim());

        String noGenerateBooleanGetMethods =
                JavaGeneratorUtil.getDoNotGenerateBooleanGetMethods(model, input);
        boolean generateBooleanGetMethods =
                StringUtils.isEmpty(noGenerateBooleanGetMethods) ||
                !"true".equals(noGenerateBooleanGetMethods.trim());

        String prefix = getConstantPrefix(input, DEFAULT_CONSTANT_PREFIX);

        setConstantPrefix(prefix);

        addSuperClass(input, output);

        boolean serializableFound = addInterfaces(input, output);

        if (superClassIsBean) {
            serializableFound = true;
        }

        addSerializable(input, output, serializableFound);

        Set<String> constantNames = addConstantsFromDependency(input, output);

        // Get available properties
        List<ObjectModelAttribute> properties = getProperties(input);

        // Add properties constant
        for (ObjectModelAttribute attr : properties) {

            createPropertyConstant(output, attr, prefix, constantNames);
        }

        // Add properties field + javabean methods
        for (ObjectModelAttribute attr : properties) {

            createProperty(output, attr, usePCS, generateBooleanGetMethods);
        }

        if (!superClassIsBean) {

            if (usePCS) {

                // Add property change support
                createPropertyChangeSupport(output);
            }
        }

        boolean hasAMultipleProperty = containsMutiple(properties);

        // Add helper operations
        if (hasAMultipleProperty) {

            if (!superClassIsBean) {

                // add getChild methods
                createGetChildMethod(output);
            }
        }
        return output;
    }

    protected void addSuperClass(ObjectModelClass input,
                                 ObjectModelClass output) {
        // Set superclass
        Iterator<ObjectModelClass> j = input.getSuperclasses().iterator();
        if (j.hasNext()) {
            ObjectModelClass p = j.next();
            String qualifiedName = p.getQualifiedName();
            setSuperClass(output, qualifiedName);
        }
    }
}
