/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.index.impl.lucene.ConnectionBroker;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.LuceneIndexImplementation;
import org.neo4j.index.impl.lucene.LuceneXaConnection;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.IndexConnectionBroker;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.index.ReadOnlyIndexConnectionBroker;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.logging.Logging;

public class LuceneIndexProvider
extends IndexProvider {
    private static List<WeakReference<LuceneIndexImplementation>> previousProviders = new ArrayList<WeakReference<LuceneIndexImplementation>>();

    public LuceneIndexProvider() {
        super("lucene");
    }

    public IndexImplementation load(DependencyResolver dependencyResolver) {
        Config config = (Config)dependencyResolver.resolveDependency(Config.class);
        InternalAbstractGraphDatabase gdb = (InternalAbstractGraphDatabase)dependencyResolver.resolveDependency(InternalAbstractGraphDatabase.class);
        TransactionManager txManager = (TransactionManager)dependencyResolver.resolveDependency(TransactionManager.class);
        IndexStore indexStore = (IndexStore)dependencyResolver.resolveDependency(IndexStore.class);
        XaFactory xaFactory = (XaFactory)dependencyResolver.resolveDependency(XaFactory.class);
        FileSystemAbstraction fileSystemAbstraction = (FileSystemAbstraction)dependencyResolver.resolveDependency(FileSystemAbstraction.class);
        XaDataSourceManager xaDataSourceManager = (XaDataSourceManager)dependencyResolver.resolveDependency(XaDataSourceManager.class);
        Logging logging = (Logging)dependencyResolver.resolveDependency(Logging.class);
        TxIdGenerator txIdGenerator = gdb.getTxIdGenerator();
        LuceneDataSource luceneDataSource = new LuceneDataSource(config, indexStore, fileSystemAbstraction, xaFactory, txIdGenerator, logging);
        xaDataSourceManager.registerDataSource((XaDataSource)luceneDataSource);
        Object broker = (Boolean)config.get(Configuration.read_only) != false ? new ReadOnlyIndexConnectionBroker(txManager) : new ConnectionBroker(txManager, luceneDataSource);
        Iterator<WeakReference<LuceneIndexImplementation>> iterator = previousProviders.iterator();
        while (iterator.hasNext()) {
            WeakReference<LuceneIndexImplementation> previousProvider = iterator.next();
            LuceneIndexImplementation indexImplementation = (LuceneIndexImplementation)previousProvider.get();
            if (indexImplementation == null) {
                iterator.remove();
                continue;
            }
            if (!indexImplementation.matches((GraphDatabaseService)gdb)) continue;
            indexImplementation.reset(luceneDataSource, (IndexConnectionBroker<LuceneXaConnection>)broker);
        }
        LuceneIndexImplementation indexImplementation = new LuceneIndexImplementation((GraphDatabaseService)gdb, luceneDataSource, (IndexConnectionBroker<LuceneXaConnection>)broker);
        previousProviders.add(new WeakReference<LuceneIndexImplementation>(indexImplementation));
        return indexImplementation;
    }

    public static abstract class Configuration {
        public static final GraphDatabaseSetting<Boolean> read_only = GraphDatabaseSettings.read_only;
    }
}

