/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jndi;

import java.lang.reflect.Method;
import java.sql.Statement;
import javax.sql.DataSource;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.log.Log;

public class DataSourceCloser
implements Destroyable {
    final DataSource _datasource;
    final String _shutdown;

    public DataSourceCloser(DataSource datasource) {
        if (datasource == null) {
            throw new IllegalArgumentException();
        }
        this._datasource = datasource;
        this._shutdown = null;
    }

    public DataSourceCloser(DataSource datasource, String shutdownSQL) {
        if (datasource == null) {
            throw new IllegalArgumentException();
        }
        this._datasource = datasource;
        this._shutdown = shutdownSQL;
    }

    @Override
    public void destroy() {
        try {
            if (this._shutdown != null) {
                Log.info("Shutdown datasource {}", this._datasource);
                Statement stmt = this._datasource.getConnection().createStatement();
                stmt.executeUpdate(this._shutdown);
                stmt.close();
            }
        }
        catch (Exception e) {
            Log.warn(e);
        }
        try {
            Method close = this._datasource.getClass().getMethod("close", new Class[0]);
            Log.info("Close datasource {}", this._datasource);
            close.invoke((Object)this._datasource, new Object[0]);
        }
        catch (Exception e) {
            Log.warn(e);
        }
    }
}

