/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.junit.jupiter.resolver;

import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class CompositeParameterResolver
implements ParameterResolver {
    private final List<ParameterResolver> delegates;

    public CompositeParameterResolver(ParameterResolver ... delegates) {
        this.delegates = List.of(delegates);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.findDelegate(parameterContext, extensionContext).isPresent();
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ParameterResolver delegate = this.findDelegate(parameterContext, extensionContext).get();
        return delegate.resolveParameter(parameterContext, extensionContext);
    }

    private Optional<ParameterResolver> findDelegate(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.delegates.stream().filter(delegate -> delegate.supportsParameter(parameterContext, extensionContext)).findFirst();
    }
}

