/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import liquibase.Liquibase;
import liquibase.command.CommandScope;
import liquibase.command.core.RegisterChangelogCommandStep;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.resource.DirectoryResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.SearchPathResourceAccessor;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;
import org.liquibase.maven.property.PropertyElement;

public class LiquibaseRegisterChangeLogMojo
extends AbstractLiquibaseChangeLogMojo {
    @PropertyElement
    protected String hubProjectId;
    @PropertyElement
    protected String hubProjectName;

    @Override
    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        super.checkRequiredParametersAreSpecified();
        if (this.hubProjectId == null && this.hubProjectName == null) {
            throw new MojoFailureException("\nEither the Hub project ID or project name must be specified.");
        }
        if (this.hubProjectId != null && this.hubProjectName != null) {
            throw new MojoFailureException("\nThe 'registerchangelog' command failed because too many parameters were provided. Command expects project ID or new projectname, but not both.\n");
        }
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        super.performLiquibaseTask(liquibase);
        Database database = liquibase.getDatabase();
        CommandScope registerChangeLog = new CommandScope(new String[]{"registerChangeLog"});
        registerChangeLog.addArgumentValue(RegisterChangelogCommandStep.CHANGELOG_FILE_ARG, (Object)this.changeLogFile).addArgumentValue(RegisterChangelogCommandStep.HUB_PROJECT_ID_ARG, this.hubProjectId != null ? UUID.fromString(this.hubProjectId) : null).addArgumentValue(RegisterChangelogCommandStep.HUB_PROJECT_NAME_ARG, (Object)this.hubProjectName);
        registerChangeLog.addArgumentValue("changeLogFile", (Object)this.changeLogFile);
        registerChangeLog.addArgumentValue("database", (Object)database);
        registerChangeLog.addArgumentValue("liquibase", (Object)liquibase);
        registerChangeLog.addArgumentValue("changeLog", (Object)liquibase.getDatabaseChangeLog());
        registerChangeLog.execute();
    }

    @Override
    protected ResourceAccessor getResourceAccessor(ClassLoader cl) throws IOException {
        ArrayList<DirectoryResourceAccessor> resourceAccessors = new ArrayList<DirectoryResourceAccessor>();
        File baseDir = this.project.getBasedir();
        File sourceDir = new File(baseDir, "src/main/resources");
        if (sourceDir.exists()) {
            resourceAccessors.add(new DirectoryResourceAccessor(sourceDir));
        }
        resourceAccessors.add(new DirectoryResourceAccessor(baseDir));
        return new SearchPathResourceAccessor(resourceAccessors.toArray(new ResourceAccessor[0]));
    }
}

