/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.mavenincrementalbuild.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public class TimestampsManager {
    private final Log LOGGER;
    private static final String FILE_NAME = "timestamp";
    private File timestampsFile;
    private String directory;
    private Map<String, Long> timestamps;

    public TimestampsManager(Log logger, String directory) throws IOException {
        this.LOGGER = logger;
        this.directory = directory;
        this.timestampsFile = new File(directory + File.separator + FILE_NAME);
        this.LOGGER.debug((CharSequence)("Timestamps file : " + this.timestampsFile.getAbsolutePath()));
    }

    public void loadPreviousTimestamps() throws IOException {
        if (this.timestampsFile.exists()) {
            this.LOGGER.debug((CharSequence)"Loading previous timestamps ...");
            ObjectInputStream input = new ObjectInputStream(new FileInputStream(this.timestampsFile));
            try {
                this.timestamps = (Map)input.readObject();
            }
            catch (ClassNotFoundException e) {
                this.LOGGER.error((CharSequence)"Error deserializing timestamp file : ", (Throwable)e);
                throw new RuntimeException("Error deserializing timestamp file.", e);
            }
            input.close();
        } else {
            this.LOGGER.debug((CharSequence)"Previous timestamps file not found.");
            this.timestamps = new HashMap<String, Long>();
        }
    }

    public void saveTimestamps() throws IOException {
        this.LOGGER.debug((CharSequence)"Saving timestamps file...");
        File dir = new File(this.directory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(this.timestampsFile));
        output.writeObject(this.timestamps);
        output.flush();
        output.close();
    }

    public Long getTimestamp(String fileName) {
        return this.timestamps.get(fileName);
    }

    public void setTimestamp(String fileName, Long timestamp) {
        this.timestamps.put(fileName, timestamp);
    }
}

