/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.mortbay.jetty.plugin.Jetty6PluginWebAppContext;
import org.mortbay.jetty.plugin.util.ConsoleScanner;
import org.mortbay.jetty.plugin.util.JettyPluginServer;
import org.mortbay.jetty.plugin.util.PluginLog;
import org.mortbay.jetty.plugin.util.SystemProperty;
import org.mortbay.start.Monitor;
import org.mortbay.util.Scanner;

public abstract class AbstractJettyMojo
extends AbstractMojo {
    protected JettyPluginServer server;
    protected Jetty6PluginWebAppContext webAppConfig;
    protected MavenProject project;
    protected String contextPath;
    protected File tmpDirectory;
    protected File webDefaultXml;
    protected File overrideWebXml;
    protected int scanIntervalSeconds;
    protected boolean consoleForceReload;
    protected SystemProperty[] systemProperties;
    protected File jettyConfig;
    protected int stopPort;
    protected String stopKey;
    protected Scanner scanner;
    protected ArrayList scanList;
    protected ArrayList scannerListeners;
    protected Thread consoleScanner;
    public String PORT_SYSPROPERTY = "jetty.port";

    public abstract Object[] getConfiguredUserRealms();

    public abstract Object[] getConfiguredConnectors();

    public abstract Object getConfiguredRequestLog();

    public abstract void checkPomConfiguration() throws MojoExecutionException;

    public abstract void configureScanner() throws MojoExecutionException;

    public abstract void applyJettyXml() throws Exception;

    public abstract JettyPluginServer createServer() throws Exception;

    public abstract void finishConfigurationBeforeStart() throws Exception;

    public MavenProject getProject() {
        return this.project;
    }

    public File getTmpDirectory() {
        return this.tmpDirectory;
    }

    public File getWebDefaultXml() {
        return this.webDefaultXml;
    }

    public File getOverrideWebXml() {
        return this.overrideWebXml;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public int getScanIntervalSeconds() {
        return this.scanIntervalSeconds;
    }

    public SystemProperty[] getSystemProperties() {
        return this.systemProperties;
    }

    public File getJettyXmlFile() {
        return this.jettyConfig;
    }

    public JettyPluginServer getServer() {
        return this.server;
    }

    public void setServer(JettyPluginServer server) {
        this.server = server;
    }

    public void setScanList(ArrayList list) {
        this.scanList = new ArrayList(list);
    }

    public ArrayList getScanList() {
        return this.scanList;
    }

    public void setScannerListeners(ArrayList listeners) {
        this.scannerListeners = new ArrayList(listeners);
    }

    public ArrayList getScannerListeners() {
        return this.scannerListeners;
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Configuring Jetty for project: " + this.getProject().getName()));
        PluginLog.setLog(this.getLog());
        this.checkPomConfiguration();
        this.startJetty();
    }

    public void startJetty() throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)"Starting Jetty Server ...");
            this.configureSystemProperties();
            this.setServer(this.createServer());
            this.applyJettyXml();
            JettyPluginServer plugin = this.getServer();
            Object[] configuredConnectors = this.getConfiguredConnectors();
            plugin.setConnectors(configuredConnectors);
            Object[] connectors = plugin.getConnectors();
            if (connectors == null || connectors.length == 0) {
                configuredConnectors = new Object[]{plugin.createDefaultConnector(System.getProperty(this.PORT_SYSPROPERTY, null))};
                plugin.setConnectors(configuredConnectors);
            }
            if (this.getConfiguredRequestLog() != null) {
                this.getServer().setRequestLog(this.getConfiguredRequestLog());
            }
            this.getServer().configureHandlers();
            this.configureWebApplication();
            this.getServer().addWebApplication(this.webAppConfig);
            Object[] configuredRealms = this.getConfiguredUserRealms();
            for (int i = 0; configuredRealms != null && i < configuredRealms.length; ++i) {
                this.getLog().debug((CharSequence)(configuredRealms[i].getClass().getName() + ": " + configuredRealms[i].toString()));
            }
            plugin.setUserRealms(configuredRealms);
            this.finishConfigurationBeforeStart();
            if (this.stopPort > 0 && this.stopKey != null) {
                System.setProperty("STOP.PORT", String.valueOf(this.stopPort));
                System.setProperty("STOP.KEY", this.stopKey);
                Monitor.monitor();
            }
            this.server.start();
            this.getLog().info((CharSequence)"Started Jetty Server");
            this.configureScanner();
            this.startScanner();
            this.startConsoleScanner();
            this.server.join();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure", e);
        }
        finally {
            this.getLog().info((CharSequence)"Jetty server exiting.");
        }
    }

    public abstract void restartWebApp(boolean var1) throws Exception;

    public void configureWebApplication() throws Exception {
        if (this.webAppConfig == null) {
            this.webAppConfig = new Jetty6PluginWebAppContext();
            this.webAppConfig.setContextPath(this.getContextPath().startsWith("/") ? this.getContextPath() : "/" + this.getContextPath());
            if (this.getTmpDirectory() != null) {
                this.webAppConfig.setTempDirectory(this.getTmpDirectory());
            }
            if (this.getWebDefaultXml() != null) {
                this.webAppConfig.setDefaultsDescriptor(this.getWebDefaultXml().getCanonicalPath());
            }
            if (this.getOverrideWebXml() != null) {
                this.webAppConfig.setOverrideDescriptor(this.getOverrideWebXml().getCanonicalPath());
            }
        }
        this.getLog().info((CharSequence)("Context path = " + this.webAppConfig.getContextPath()));
        this.getLog().info((CharSequence)"Tmp directory =  determined at runtime");
        this.getLog().info((CharSequence)("Web defaults = " + (this.webAppConfig.getDefaultsDescriptor() == null ? " jetty default" : this.webAppConfig.getDefaultsDescriptor())));
        this.getLog().info((CharSequence)("Web overrides = " + (this.webAppConfig.getOverrideDescriptor() == null ? " none" : this.webAppConfig.getOverrideDescriptor())));
    }

    private void startScanner() {
        Iterator itor;
        if (this.getScanIntervalSeconds() <= 0) {
            return;
        }
        if (this.consoleForceReload) {
            this.getLog().warn((CharSequence)("scanIntervalSeconds is set to " + this.scanIntervalSeconds + " but will be IGNORED due to consoleForceReload"));
            return;
        }
        this.scanner = new Scanner();
        this.scanner.setReportExistingFilesOnStartup(false);
        this.scanner.setScanInterval(this.getScanIntervalSeconds());
        this.scanner.setScanDirs((List)this.getScanList());
        ArrayList listeners = this.getScannerListeners();
        Iterator iterator = itor = listeners == null ? null : listeners.iterator();
        while (itor != null && itor.hasNext()) {
            this.scanner.addListener((Scanner.Listener)itor.next());
        }
        this.getLog().info((CharSequence)("Starting scanner at interval of " + this.getScanIntervalSeconds() + " seconds."));
        this.scanner.start();
    }

    protected void startConsoleScanner() {
        if (this.consoleForceReload) {
            this.getLog().info((CharSequence)"Console reloading is ENABLED. Hit ENTER on the console to restart the context.");
            this.consoleScanner = new ConsoleScanner(this);
            this.consoleScanner.start();
        }
    }

    private void configureSystemProperties() {
        for (int i = 0; this.getSystemProperties() != null && i < this.getSystemProperties().length; ++i) {
            boolean result = this.getSystemProperties()[i].setIfNotSetAlready();
            this.getLog().info((CharSequence)("Property " + this.getSystemProperties()[i].getName() + "=" + this.getSystemProperties()[i].getValue() + " was " + (result ? "set" : "skipped")));
        }
    }

    public File findJettyWebXmlFile(File webInfDir) {
        if (webInfDir == null) {
            return null;
        }
        if (!webInfDir.exists()) {
            return null;
        }
        File f = new File(webInfDir, "jetty-web.xml");
        if (f.exists()) {
            return f;
        }
        f = new File(webInfDir, "web-jetty.xml");
        if (f.exists()) {
            return f;
        }
        f = new File(webInfDir, "jetty6-web.xml");
        if (f.exists()) {
            return f;
        }
        return null;
    }
}

