/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.nio.file.FileSystem;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.FileKt;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;
import org.jetbrains.kotlin.library.impl.KotlinLibraryLayoutImpl;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0001\u00a8\u0006\n"}, d2={"extract", "Lorg/jetbrains/kotlin/konan/file/File;", "zipFile", "file", "extractDir", "directory", "zippedKotlinLibraryChecks", "", "klibFile", "Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutImpl;", "kotlin-util-klib"})
public final class KotlinLibraryLayoutImplKt {
    @NotNull
    public static final File extract(@NotNull KotlinLibraryLayoutImpl $this$extract, @NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)$this$extract, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return KotlinLibraryLayoutImplKt.extract($this$extract.getKlib(), file2);
    }

    private static final File extract(File zipFile, File file2) {
        return (File)ZipUtilKt.withZipFileSystem((File)zipFile, (Function1)((Function1)new Function1<FileSystem, File>(file2){
            final /* synthetic */ File $file;
            {
                this.$file = $file;
                super(1);
            }

            @NotNull
            public final File invoke(@NotNull FileSystem zipFileSystem) {
                Intrinsics.checkNotNullParameter((Object)zipFileSystem, (String)"zipFileSystem");
                File temporary = FileKt.createTempFile$default((String)this.$file.getName(), null, (int)2, null);
                ZipUtilKt.file((FileSystem)zipFileSystem, (File)this.$file).copyTo(temporary);
                temporary.deleteOnExit();
                return temporary;
            }
        }));
    }

    @NotNull
    public static final File extractDir(@NotNull KotlinLibraryLayoutImpl $this$extractDir, @NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)$this$extractDir, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return KotlinLibraryLayoutImplKt.extractDir($this$extractDir.getKlib(), directory);
    }

    private static final File extractDir(File zipFile, File directory) {
        return (File)ZipUtilKt.withZipFileSystem((File)zipFile, (Function1)((Function1)new Function1<FileSystem, File>(directory){
            final /* synthetic */ File $directory;
            {
                this.$directory = $directory;
                super(1);
            }

            @NotNull
            public final File invoke(@NotNull FileSystem zipFileSystem) {
                Intrinsics.checkNotNullParameter((Object)zipFileSystem, (String)"zipFileSystem");
                File temporary = FileKt.createTempDir((String)this.$directory.getName());
                File.recursiveCopyTo$default((File)ZipUtilKt.file((FileSystem)zipFileSystem, (File)this.$directory), (File)temporary, (boolean)false, (int)2, null);
                temporary.deleteOnExitRecursively();
                return temporary;
            }
        }));
    }

    public static final void zippedKotlinLibraryChecks(@NotNull File klibFile) {
        Intrinsics.checkNotNullParameter((Object)klibFile, (String)"klibFile");
        boolean bl = klibFile.getExists();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Could not find " + klibFile + '.';
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        bl = klibFile.isFile();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string3 = "Expected " + klibFile + " to be a regular file.";
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        String extension = klibFile.getExtension();
        CharSequence charSequence = extension;
        bl3 = false;
        boolean bl6 = charSequence.length() == 0 || Intrinsics.areEqual((Object)extension, (Object)"klib") || Intrinsics.areEqual((Object)extension, (Object)"jar");
        bl3 = false;
        boolean bl7 = false;
        if (!bl6) {
            boolean bl8 = false;
            String string4 = Intrinsics.stringPlus((String)"KLIB path has unexpected extension: ", (Object)klibFile);
            throw (Throwable)new IllegalStateException(string4.toString());
        }
    }
}

