/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.thirdparty.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.jboss.maven.plugins.thirdparty.util.JarFileEntry;

public class JarUtil {
    public static List getJarEntries(File basedir) throws IOException {
        String[] includes = new String[]{"**"};
        String[] excludes = null;
        return JarUtil.getJarEntries(basedir, includes, excludes);
    }

    public static List getJarEntries(File basedir, String[] includes, String[] excludes) throws IOException {
        ArrayList<JarFileEntry> fileEntries = new ArrayList<JarFileEntry>();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(basedir);
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.addDefaultExcludes();
        scanner.scan();
        String[] filenames = scanner.getIncludedFiles();
        for (int i = 0; i < filenames.length; ++i) {
            String fileContents = FileUtils.fileRead((File)new File(basedir, filenames[i]));
            byte[] fileData = IOUtil.toByteArray((String)fileContents);
            fileEntries.add(new JarFileEntry(filenames[i], fileData));
        }
        return fileEntries;
    }

    public static void writeJarFile(List jarFileEntries, File outputJar) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        attributes.putValue("Created-By", System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
        JarOutputStream stream = new JarOutputStream((OutputStream)new FileOutputStream(outputJar), manifest);
        stream.setLevel(9);
        for (JarFileEntry entry : jarFileEntries) {
            JarEntry jarEntry = new JarEntry(entry.getName());
            stream.putNextEntry(jarEntry);
            stream.write(entry.getContent());
        }
        stream.close();
    }

    public static void extractJarFile(File jarFile, File outputDirectory) throws IOException {
        JarFile theJarFile = new JarFile(jarFile);
        Enumeration<JarEntry> entries = theJarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || entry.getName().startsWith("META-INF")) continue;
            InputStream jis = theJarFile.getInputStream(entry);
            File outFile = new File(outputDirectory, entry.getName());
            if (outFile.getParentFile().isFile()) {
                outFile.getParentFile().delete();
            }
            if (!outFile.getParentFile().exists()) {
                FileUtils.mkdir((String)outFile.getParentFile().getAbsolutePath());
            }
            FileOutputStream out = new FileOutputStream(outFile);
            IOUtil.copy((InputStream)jis, (OutputStream)out);
            jis.close();
            out.close();
        }
    }
}

