/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.thirdparty;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.License;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.jboss.maven.plugins.thirdparty.ComponentInfo;
import org.jboss.maven.plugins.thirdparty.ComponentInfoReader;
import org.jboss.maven.plugins.thirdparty.ComponentInfoWriter;
import org.xml.sax.SAXException;

public class ThirdpartyDeployMojo
extends AbstractMojo {
    private static String fileSep = System.getProperty("file.separator");
    protected MavenProject project;
    private Scm scm;
    private List pomLicenses;
    private String license;
    private boolean removeArtifactVersion;
    protected Properties projectProperties;
    private String thirdpartyRepositoryDir;
    private boolean generateImports;
    private Map imports;
    private String artifactId;
    private String componentId;
    private String componentVersion;
    private Set exports;
    private boolean skip;

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Executing JBoss deploy plugin");
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution of jboss-deploy plugin");
            return;
        }
        if ((this.project.getArtifact() == null || this.project.getArtifact().getFile() == null) && this.project.getAttachedArtifacts().size() == 0) {
            this.getLog().info((CharSequence)("No artifacts to deploy for project:" + this.project.getName()));
            return;
        }
        if (this.exports == null) {
            this.exports = new HashSet();
        }
        ComponentInfo compInfo = new ComponentInfo();
        compInfo.setComponentId(this.componentId);
        compInfo.setVersion(this.componentVersion);
        File componentBaseDir = new File(this.thirdpartyRepositoryDir, compInfo.getComponentId());
        System.out.println(componentBaseDir);
        File componentVersionDir = new File(componentBaseDir, this.componentVersion);
        System.out.println(componentVersionDir);
        File componentLibDir = new File(componentVersionDir, "lib");
        if (this.license != null && !this.license.equals("")) {
            compInfo.setLicense(this.license);
        } else if (this.pomLicenses.size() == 0) {
            this.getLog().warn((CharSequence)"No license specified.  Default lgpl license will be used.");
            compInfo.setLicense("lgpl");
        } else {
            License firstLicense = (License)this.pomLicenses.get(0);
            compInfo.setLicense(firstLicense.getName());
        }
        if (this.project.getDescription() == null || this.project.getDescription().equals("")) {
            this.project.setDescription(this.project.getId());
        }
        compInfo.setDescription(this.project.getDescription());
        if (this.scm != null && this.scm.getConnection() != null) {
            String scmConnStr = this.scm.getConnection().replaceFirst("scm:", "");
            compInfo.setScm("scm=\"" + scmConnStr + "\"");
        }
        HashSet<String> artifactSet = new HashSet<String>();
        Artifact projectArtifact = this.project.getArtifact();
        if (projectArtifact != null && projectArtifact.getFile() != null) {
            String deployFileName = this.generateOutputFileName(projectArtifact, this.removeArtifactVersion);
            artifactSet.add("    <artifact id=\"" + deployFileName + "\"/>\n");
            try {
                this.getLog().debug((CharSequence)("Deploying file://" + componentLibDir + fileSep + deployFileName));
                FileUtils.copyFile((File)projectArtifact.getFile(), (File)new File(componentLibDir, deployFileName));
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Problem copying artifact: " + ioe.getMessage());
            }
        }
        List list = this.project.getAttachedArtifacts();
        this.getLog().debug((CharSequence)("Number of attached artifacts: " + list.size()));
        for (Artifact artifact : list) {
            String componentArtifactFileName;
            this.getLog().debug((CharSequence)("Attaching artifact: " + artifact.getArtifactId()));
            String classifierStr = artifact.getClassifier();
            if (classifierStr == null) {
                classifierStr = "";
                if (artifact.getArtifactId().equals(this.project.getArtifactId())) {
                    this.exports.add(this.artifactId + "." + artifact.getType());
                }
                if (this.project.getArtifact() != null) {
                    this.getLog().warn((CharSequence)("Attached artifact with same classifier as default artifact.\nAttached artifact: " + artifact.getFile() + "\n" + "Project artifact: " + this.project.getArtifact().getFile() + "\n" + "This could be caused by an assembly descriptor with no id."));
                }
            }
            if (compInfo.containsArtifactId(componentArtifactFileName = this.generateOutputFileName(artifact, this.removeArtifactVersion))) {
                this.getLog().warn((CharSequence)("Duplicate attached artifact found: " + componentArtifactFileName));
            }
            compInfo.addArtifactId(componentArtifactFileName);
            try {
                this.getLog().debug((CharSequence)("Deploying file://" + componentLibDir + fileSep + componentArtifactFileName));
                File componentArtifactFile = new File(componentLibDir, componentArtifactFileName);
                FileUtils.copyFile((File)artifact.getFile(), (File)componentArtifactFile);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Problem copying artifact: " + ioe.getMessage());
            }
        }
        StringBuffer exportsString = new StringBuffer();
        if (this.project.getArtifact().getFile() != null) {
            compInfo.addExport(this.generateOutputFileName(this.project.getArtifact(), this.removeArtifactVersion));
        }
        this.addImports(compInfo);
        File compInfoFile = new File(componentVersionDir, "component-info.xml");
        try {
            if (!componentVersionDir.exists()) {
                componentVersionDir.mkdirs();
            }
            this.getLog().info((CharSequence)("Deploying file: " + compInfoFile.getCanonicalPath()));
            ComponentInfoWriter.loadTemplate();
            ComponentInfoWriter.writeComponentInfo(compInfo, compInfoFile);
        }
        catch (IOException ioe) {
            this.getLog().error((Throwable)ioe);
        }
        ComponentInfoReader verifier = new ComponentInfoReader();
        try {
            ComponentInfoReader.verifyCompInfo(new FileInputStream(compInfoFile));
        }
        catch (SAXException e) {
            this.getLog().warn((Throwable)e);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
    }

    private String generateOutputFileName(Artifact artifact, boolean removeArtifactVersion) {
        String deployFileName = artifact.getFile().getName();
        if (removeArtifactVersion && deployFileName.contains("-" + artifact.getBaseVersion())) {
            deployFileName = deployFileName.replace("-" + artifact.getBaseVersion(), "");
        }
        if (!this.project.getArtifactId().equals(this.artifactId) && deployFileName.contains(this.project.getArtifactId())) {
            deployFileName = deployFileName.replace(this.project.getArtifactId(), this.artifactId);
        }
        return deployFileName;
    }

    private void addImports(ComponentInfo compInfo) {
        StringBuffer importsString = new StringBuffer();
        if (this.imports != null) {
            Set componentNames = this.imports.keySet();
            for (String componentId : componentNames) {
                String compatibleVersions = (String)this.imports.get(componentId);
                compInfo.addImport(componentId, compatibleVersions);
            }
        }
        if (this.generateImports) {
            List dependencies = this.project.getDependencies();
            for (Dependency dep : dependencies) {
                if (dep.getScope() != null && dep.getScope().equals("test")) continue;
                String componentId = dep.getGroupId().replace('.', '/');
                String compatibleVersions = dep.getVersion();
                compInfo.addImport(componentId, compatibleVersions);
            }
        }
    }
}

