/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.thirdparty;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.jboss.maven.plugins.thirdparty.ComponentInfo;
import org.jboss.maven.plugins.thirdparty.ComponentInfoReader;
import org.jboss.maven.plugins.thirdparty.util.FileUtil;
import org.jboss.maven.plugins.thirdparty.util.JarUtil;

public class MavenDeployMojo
extends AbstractMojo {
    public static final Set KNOWN_EXTENSIONS = new HashSet();
    private ArtifactDeployer deployer;
    private ArtifactRepository localRepository;
    private String groupId;
    private File componentDir;
    private String version;
    private String description;
    private String repositoryId;
    private String repositoryLayout;
    private Map repositoryLayouts;
    private String url;
    private String license;
    private ArtifactFactory artifactFactory;
    private ArtifactRepositoryFactory repositoryFactory;
    private boolean uniqueVersion;
    private String[] resourceIncludes;
    private String[] resourceExcludes;
    private String classifiers;
    private String[] classifierList;

    public void execute() throws MojoExecutionException {
        if (!this.componentDir.isDirectory()) {
            throw new MojoExecutionException(this.componentDir.getPath() + " does not exist or is not a directory.");
        }
        File compInfoFile = new File(this.componentDir, "component-info.xml");
        if (!compInfoFile.exists()) {
            this.getLog().error((CharSequence)("Unable to locate component-info.xml : " + compInfoFile));
            throw new MojoExecutionException("Unable to locate component-info.xml");
        }
        ArtifactRepositoryLayout layout = (ArtifactRepositoryLayout)this.repositoryLayouts.get(this.repositoryLayout);
        ArtifactRepository deploymentRepository = this.repositoryFactory.createDeploymentArtifactRepository(this.repositoryId, this.url, layout, this.uniqueVersion);
        String protocol = deploymentRepository.getProtocol();
        if ("".equals(protocol) || protocol == null) {
            throw new MojoExecutionException("No transfer protocol found. This could be caused by an invalid url: " + this.url);
        }
        ComponentInfo compInfo = null;
        try {
            compInfo = ComponentInfoReader.parseComponentInfo(compInfoFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to read component-info.xml", e);
        }
        File componentLibDir = new File(this.componentDir, "lib");
        this.classifiers = this.classifiers.trim();
        this.classifierList = this.classifiers.split("\\s*\\,\\s*");
        Map pomToArtifactMap = this.mapPomsToArtifacts(compInfo, componentLibDir);
        for (File pomFile : pomToArtifactMap.keySet()) {
            List pomArtifacts = (List)pomToArtifactMap.get(pomFile);
            Model model = this.readModel(pomFile);
            if (model.getGroupId() == null) {
                model.setGroupId(model.getParent().getGroupId());
            }
            if (model.getVersion() == null) {
                model.setVersion(model.getParent().getVersion());
            }
            boolean modelChanged = false;
            if (this.groupId != null) {
                model.setGroupId(this.groupId);
                modelChanged = true;
            }
            if (this.version != null) {
                model.setVersion(this.version);
                modelChanged = true;
            }
            if (this.description != null) {
                model.setDescription(this.description);
                modelChanged = true;
            }
            if (modelChanged || !pomFile.exists()) {
                pomFile = this.writeModel(model);
            }
            if (pomArtifacts.isEmpty()) {
                String packaging = "pom";
                String classifier = null;
                Artifact artifact = this.artifactFactory.createArtifactWithClassifier(model.getGroupId(), model.getArtifactId(), model.getVersion(), packaging, classifier);
                ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pomFile);
                artifact.addMetadata((ArtifactMetadata)metadata);
                try {
                    this.getDeployer().deploy(pomFile, artifact, deploymentRepository, this.getLocalRepository());
                    continue;
                }
                catch (ArtifactDeploymentException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                }
            }
            for (int i = 0; i < pomArtifacts.size(); ++i) {
                File artifactFile = (File)pomArtifacts.get(i);
                String packaging = FileUtil.getFileExtension(artifactFile.getName());
                String baseArtifactName = FileUtil.removeFileExtension(artifactFile.getName());
                String classifier = null;
                for (int j = 0; j < this.classifierList.length; ++j) {
                    if (!baseArtifactName.endsWith("-" + this.classifierList[j])) continue;
                    classifier = this.classifierList[j];
                }
                if (classifier != null && model.getVersion().endsWith("-SNAPSHOT")) {
                    this.getLog().info((CharSequence)("Skipping deployment of source jar because of SNAPSHOT version: " + artifactFile.getName()));
                    continue;
                }
                Artifact artifact = this.artifactFactory.createArtifactWithClassifier(model.getGroupId(), model.getArtifactId(), model.getVersion(), packaging, classifier);
                ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pomFile);
                artifact.addMetadata((ArtifactMetadata)metadata);
                try {
                    this.getDeployer().deploy(artifactFile, artifact, deploymentRepository, this.getLocalRepository());
                    continue;
                }
                catch (ArtifactDeploymentException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                }
            }
        }
        this.deployResources(compInfo, deploymentRepository);
    }

    private Map mapPomsToArtifacts(ComponentInfo compInfo, File componentLibDir) throws MojoExecutionException {
        File[] fileList = componentLibDir.listFiles();
        HashMap pomToArtifactMap = new HashMap();
        Stack<File> artifactStack = new Stack<File>();
        for (int i = 0; i < fileList.length; ++i) {
            if (fileList[i].isDirectory()) continue;
            if (fileList[i].getName().endsWith(".pom")) {
                pomToArtifactMap.put(fileList[i], new ArrayList());
                continue;
            }
            String fileExtension = FileUtils.getExtension((String)fileList[i].getName());
            if (KNOWN_EXTENSIONS.contains(fileExtension)) {
                artifactStack.add(fileList[i]);
                continue;
            }
            this.getLog().info((CharSequence)("Skipping file: " + fileList[i].getName()));
            this.getLog().info((CharSequence)("Unknown packaging: " + fileExtension));
        }
        while (!artifactStack.isEmpty()) {
            int dashIndex;
            File nextArtifact = (File)artifactStack.pop();
            String artifactName = FileUtil.removeFileExtension(nextArtifact.getName());
            for (int i = 0; i < this.classifierList.length; ++i) {
                artifactName = artifactName.replace("-" + this.classifierList[i], "");
            }
            if (artifactName.contains("-") && Character.isDigit(artifactName.charAt((dashIndex = artifactName.lastIndexOf(45)) + 1))) {
                artifactName = artifactName.substring(0, dashIndex);
            }
            String pomName = artifactName + ".pom";
            File pomFile = new File(componentLibDir, pomName);
            if (!pomToArtifactMap.keySet().contains(pomFile)) {
                pomFile = this.generatePomFile(compInfo, nextArtifact);
                ArrayList<File> pomArtifactList = new ArrayList<File>();
                pomArtifactList.add(nextArtifact);
                pomToArtifactMap.put(pomFile, pomArtifactList);
            }
            List artifactList = (List)pomToArtifactMap.get(pomFile);
            artifactList.add(nextArtifact);
        }
        return pomToArtifactMap;
    }

    protected Model readModel(File pomFile) throws MojoExecutionException {
        if (!pomFile.exists()) {
            throw new MojoExecutionException("Specified pomFile does not exist");
        }
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)pomFile);
            MavenXpp3Reader modelReader = new MavenXpp3Reader();
            Model model = modelReader.read((Reader)reader);
            return model;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading specified POM file: " + e.getMessage(), e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    public File writeModel(Model model) throws MojoExecutionException {
        File file;
        XmlStreamWriter fw = null;
        try {
            File tempFile = File.createTempFile(model.getArtifactId(), ".pom");
            tempFile.deleteOnExit();
            fw = WriterFactory.newXmlWriter((File)tempFile);
            new MavenXpp3Writer().write((Writer)fw, model);
            file = tempFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary pom file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fw);
                throw throwable;
            }
        }
        IOUtil.close((Writer)fw);
        return file;
    }

    private void deployResources(ComponentInfo compInfo, ArtifactRepository deploymentRepository) throws MojoExecutionException {
        if (this.resourceIncludes == null) {
            this.resourceIncludes = new String[2];
            this.resourceIncludes[0] = "resources/**";
            this.resourceIncludes[1] = "bin/**";
        }
        List jarEntries = null;
        try {
            jarEntries = JarUtil.getJarEntries(this.componentDir, this.resourceIncludes, this.resourceExcludes);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Problem reading resources: " + e));
        }
        if (jarEntries == null || jarEntries.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)"Found resources, creating jar for deployment");
        String mavenGroupId = this.groupId;
        if (mavenGroupId == null) {
            mavenGroupId = compInfo.getComponentId().replace('/', '.');
        }
        String mavenArtifactId = "resources";
        String packaging = "jar";
        String classifier = null;
        String mavenVersion = this.version;
        if (mavenVersion == null) {
            mavenVersion = compInfo.getVersion();
        }
        Model model = this.generateModel(mavenGroupId, mavenArtifactId, mavenVersion, packaging, this.license);
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(model.getGroupId(), model.getArtifactId(), model.getVersion(), model.getPackaging(), classifier);
        ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, this.writeModel(model));
        artifact.addMetadata((ArtifactMetadata)metadata);
        try {
            String tempJarFileName = "resources";
            File tempJarFile = File.createTempFile(tempJarFileName, "jar");
            JarUtil.writeJarFile(jarEntries, tempJarFile);
            this.getDeployer().deploy(tempJarFile, artifact, deploymentRepository, this.getLocalRepository());
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Problem while writing jar file: " + e));
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public String getArtifactBaseName(String artifactFileName) {
        artifactFileName = FileUtil.removeFileExtension(artifactFileName);
        artifactFileName = FileUtil.removeSourceQualifier(artifactFileName);
        return artifactFileName;
    }

    private File generatePomFile(ComponentInfo compInfo, File artifactFile) throws MojoExecutionException {
        String groupId = compInfo.getComponentId().replace('/', '.');
        String artifactId = this.getArtifactBaseName(artifactFile.getName());
        String artifactVersion = compInfo.getVersion();
        String packaging = FileUtils.getExtension((String)artifactFile.getName());
        String license = compInfo.getLicense();
        Model model = this.generateModel(groupId, artifactId, artifactVersion, packaging, license);
        File pomFile = this.writeModel(model);
        return pomFile;
    }

    private Model generateModel(String groupId, String artifactId, String artifactVersion, String packaging, String license) throws MojoExecutionException {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(groupId);
        model.setArtifactId(artifactId);
        model.setVersion(artifactVersion);
        model.setPackaging(packaging);
        model.setDescription(this.description);
        if (license != null) {
            License theLicense = new License();
            theLicense.setName(license);
            model.addLicense(theLicense);
        }
        return model;
    }

    void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    void setVersion(String version) {
        this.version = version;
    }

    String getGroupId() {
        return this.groupId;
    }

    String getVersion() {
        return this.version;
    }

    public ArtifactDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(ArtifactDeployer deployer) {
        this.deployer = deployer;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    static {
        KNOWN_EXTENSIONS.add("jar");
        KNOWN_EXTENSIONS.add("war");
        KNOWN_EXTENSIONS.add("zip");
        KNOWN_EXTENSIONS.add("sar");
    }
}

