/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.thirdparty;

import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.StringUtils;
import org.jboss.maven.plugins.thirdparty.Mapping;

public class Dependency
extends org.apache.maven.model.Dependency {
    private Mapping mapping = new Mapping();
    private boolean exportArtifact = true;

    public Dependency() {
    }

    public Dependency(Artifact artifact) {
        this.setGroupId(artifact.getGroupId());
        this.setArtifactId(artifact.getArtifactId());
        this.setVersion(artifact.getVersion());
        this.setClassifier(artifact.getClassifier());
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public void setMapping(Mapping mapping) {
        this.mapping = mapping;
    }

    public String getComponentId() {
        if (this.mapping.getComponentId() == null) {
            this.mapping.setComponentId(this.getGroupId());
        }
        return this.mapping.getComponentId();
    }

    public void setComponentId(String componentId) {
        this.mapping.setComponentId(componentId);
    }

    public String getComponentVersion() {
        if (this.mapping.getVersion() == null) {
            this.mapping.setVersion(this.getVersion());
        }
        return this.mapping.getVersion();
    }

    public String getCompArtifactId() {
        if (this.mapping.getArtifactId() == null) {
            String compArtifactId = this.getArtifactId();
            if (this.getClassifier() != null) {
                compArtifactId = compArtifactId + "-" + this.getClassifier();
            }
            this.mapping.setArtifactId(compArtifactId);
        }
        return this.mapping.getArtifactId();
    }

    public boolean equals(Object dependency) {
        if (!(dependency instanceof Dependency)) {
            return false;
        }
        Dependency compare = (Dependency)((Object)dependency);
        if (!this.getGroupId().equals(compare.getGroupId())) {
            return false;
        }
        if (!this.getArtifactId().equals(compare.getArtifactId())) {
            return false;
        }
        if (!StringUtils.equals((String)this.getClassifier(), (String)compare.getClassifier())) {
            return false;
        }
        return StringUtils.equals((String)this.getType(), (String)compare.getType());
    }

    public String getResolutionId() {
        StringBuffer resId = new StringBuffer();
        resId.append(this.getGroupId() + ":" + this.getArtifactId());
        if (this.getClassifier() != null) {
            resId.append(":" + this.getClassifier());
        }
        return resId.toString();
    }

    public int hashCode() {
        return this.getResolutionId().hashCode();
    }

    public boolean isExportArtifact() {
        return this.exportArtifact;
    }

    public void setExportArtifact(boolean exportArtifact) {
        this.exportArtifact = exportArtifact;
    }
}

