/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.metadata;

import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.system.metadata.ServiceAnnotationMetaData;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceDependencyListValueMetaData;
import org.jboss.system.metadata.ServiceDependencyMetaData;
import org.jboss.system.metadata.ServiceDependencyValueMetaData;
import org.jboss.system.metadata.ServiceElementValueMetaData;
import org.jboss.system.metadata.ServiceInjectionValueMetaData;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceTextValueMetaData;
import org.jboss.system.metadata.ServiceValueFactoryParameterMetaData;
import org.jboss.system.metadata.ServiceValueFactoryValueMetaData;
import org.jboss.system.metadata.ServiceValueMetaData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServiceMetaData2ElementConverter {
    private final Document document;

    public ServiceMetaData2ElementConverter() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.newDocument();
    }

    public Element createServiceMetaDataElement(ServiceMetaData metaData) throws Exception {
        List<ServiceAnnotationMetaData> annotations;
        List<String> aliases;
        List<ServiceDependencyMetaData> dependencies;
        if (metaData == null) {
            throw new IllegalArgumentException("Null meta data.");
        }
        Element mbean = this.document.createElement("mbean");
        this.setObjectName(metaData, mbean);
        this.setCode(metaData, mbean);
        this.setControllerMode(metaData, mbean);
        this.addConstructor(metaData, mbean);
        this.setInterface(metaData, mbean);
        this.setXmbeanAttributes(metaData, mbean);
        List<ServiceAttributeMetaData> attributes = metaData.getAttributes();
        if (attributes != null && !attributes.isEmpty()) {
            for (ServiceAttributeMetaData attributeMetaData : attributes) {
                this.addAttributes(attributeMetaData, mbean);
            }
        }
        if ((dependencies = metaData.getDependencies()) != null && !dependencies.isEmpty()) {
            for (ServiceDependencyMetaData dependency : dependencies) {
                this.addDependency(dependency, mbean);
            }
        }
        if ((aliases = metaData.getAliases()) != null && !aliases.isEmpty()) {
            for (String alias : aliases) {
                this.addAlias(alias, mbean);
            }
        }
        if ((annotations = metaData.getAnnotations()) != null && !annotations.isEmpty()) {
            for (ServiceAnnotationMetaData annotation : annotations) {
                this.addAnnotation(annotation, mbean);
            }
        }
        return mbean;
    }

    private void setObjectName(ServiceMetaData metaData, Element mbean) {
        if (metaData.getObjectName() != null) {
            mbean.setAttribute("name", metaData.getObjectName().getCanonicalName());
        }
    }

    private void setCode(ServiceMetaData metaData, Element mbean) {
        if (metaData.getCode() != null) {
            mbean.setAttribute("code", metaData.getCode());
        }
    }

    private void setControllerMode(ServiceMetaData metaData, Element mbean) {
        ControllerMode mode = metaData.getMode();
        if (mode != null) {
            mbean.setAttribute("mode", mode.getModeString());
        }
    }

    private void addConstructor(ServiceMetaData metaData, Element mbean) throws Exception {
        ServiceConstructorMetaData constructorMetaData = metaData.getConstructor();
        if (constructorMetaData == null) {
            return;
        }
        Element constructor = this.document.createElement("constructor");
        String[] params = constructorMetaData.getParams();
        if (params == null || params.length == 0) {
            return;
        }
        String[] signature = constructorMetaData.getSignature();
        if (signature.length != params.length) {
            return;
        }
        int i = params.length;
        for (int j = 0; j < i; ++j) {
            Element arg = this.document.createElement("arg");
            arg.setAttribute("type", signature[j]);
            arg.setAttribute("value", params[j]);
            constructor.appendChild(arg);
        }
        mbean.appendChild(constructor);
    }

    private void setInterface(ServiceMetaData metaData, Element mbean) {
        if (metaData.getInterfaceName() != null) {
            mbean.setAttribute("interface", metaData.getInterfaceName());
        }
    }

    private void setXmbeanAttributes(ServiceMetaData metaData, Element mbean) {
        if (metaData.getXMBeanDD() != null) {
            mbean.setAttribute("xmbean-dd", metaData.getXMBeanDD());
        }
        if (metaData.getXMBeanCode() != null) {
            mbean.setAttribute("xmbean-code", metaData.getXMBeanCode());
        }
        if (metaData.getXMBeanDescriptor() != null) {
            mbean.appendChild(metaData.getXMBeanDescriptor());
        }
    }

    private void addAttributes(ServiceAttributeMetaData attributeMetaData, Element mbean) {
        Element attribute = this.document.createElement("attribute");
        attribute.setAttribute("name", attributeMetaData.getName());
        ServiceValueMetaData attributeValue = attributeMetaData.getValue();
        if (attributeValue instanceof ServiceElementValueMetaData) {
            ServiceElementValueMetaData value = (ServiceElementValueMetaData)attributeValue;
            attribute = value.getElement();
        } else if (attributeValue instanceof ServiceTextValueMetaData) {
            ServiceTextValueMetaData value = (ServiceTextValueMetaData)attributeValue;
            attribute.setTextContent(value.getText());
        } else if (attributeValue instanceof ServiceDependencyValueMetaData) {
            attribute = null;
            ServiceDependencyValueMetaData dependsMetaData = (ServiceDependencyValueMetaData)attributeValue;
            this.addDependsValue(attributeMetaData.getName(), dependsMetaData, mbean);
        } else if (attributeValue instanceof ServiceDependencyListValueMetaData) {
            attribute = null;
            Element dependsList = this.document.createElement("depends-list");
            dependsList.setAttribute("optional-attribute-name", attributeMetaData.getName());
            ServiceDependencyListValueMetaData dependencyList = (ServiceDependencyListValueMetaData)attributeValue;
            List<String> dependencies = dependencyList.getDependencies();
            if (dependencies != null && !dependencies.isEmpty()) {
                for (String dependency : dependencies) {
                    Element dependsElement = this.document.createElement("depends-list-element");
                    dependsElement.setTextContent(dependency);
                    dependsList.appendChild(dependsElement);
                }
                mbean.appendChild(dependsList);
            }
        } else if (attributeValue instanceof ServiceInjectionValueMetaData) {
            Element inject = this.document.createElement("inject");
            ServiceInjectionValueMetaData value = (ServiceInjectionValueMetaData)attributeValue;
            inject.setAttribute("bean", (String)value.getDependency());
            if (value.getProperty() != null) {
                inject.setAttribute("property", value.getProperty());
            }
            if (value.getDependentState() != null) {
                inject.setAttribute("state", value.getDependentState().getStateString());
            }
            attribute.appendChild(inject);
        } else if (attributeValue instanceof ServiceValueFactoryValueMetaData) {
            List<ServiceValueFactoryParameterMetaData> parameters;
            Element factory = this.document.createElement("value-factory");
            ServiceValueFactoryValueMetaData value = (ServiceValueFactoryValueMetaData)attributeValue;
            factory.setAttribute("bean", (String)value.getDependency());
            factory.setAttribute("method", value.getMethod());
            if (value.getDefaultValue() != null) {
                factory.setAttribute("default", value.getDefaultValue().getText());
            }
            if (value.getDependentState() != null) {
                factory.setAttribute("state", value.getDependentState().getStateString());
            }
            if ((parameters = value.getParameterMetaData()) != null && !parameters.isEmpty()) {
                for (ServiceValueFactoryParameterMetaData param : parameters) {
                    Element parameter = this.document.createElement("parameter");
                    if (param.getParameterTypeName() != null) {
                        parameter.setAttribute("class", param.getParameterTypeName());
                    }
                    if (param.getValueTypeName() != null) {
                        Element parameterValue = this.document.createElement("value");
                        parameterValue.setAttribute("class", param.getValueTypeName());
                        parameterValue.setTextContent(param.getTextValue());
                        parameter.appendChild(parameterValue);
                    } else {
                        parameter.setTextContent(param.getTextValue());
                    }
                    factory.appendChild(parameter);
                }
            }
            attribute.appendChild(factory);
        }
        if (attribute != null) {
            mbean.appendChild(attribute);
        }
    }

    private void addDependency(ServiceDependencyMetaData dependencyMetaData, Element mbean) {
        Element depends = this.document.createElement("depends");
        depends.setTextContent(dependencyMetaData.getIDependOn());
        mbean.appendChild(depends);
    }

    private void addAlias(String alias, Element mbean) {
        Element a = this.document.createElement("alias");
        a.setTextContent(alias);
        mbean.appendChild(a);
    }

    private void addAnnotation(ServiceAnnotationMetaData annotation, Element mbean) {
        Element a = this.document.createElement("annotation");
        a.setTextContent(annotation.getAnnotation());
        mbean.appendChild(a);
    }

    private void addDependsValue(String name, ServiceDependencyValueMetaData dependsMetaData, Element mbean) {
        Element depends = this.document.createElement("depends");
        depends.setAttribute("optional-attribute-name", name);
        if (dependsMetaData.getProxyType() != null) {
            depends.setAttribute("proxy-type", dependsMetaData.getProxyType());
        }
        depends.setTextContent(dependsMetaData.getDependency());
        mbean.appendChild(depends);
    }
}

