/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers;

import java.io.ByteArrayInputStream;
import java.util.Properties;
import javax.management.ObjectName;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.version.Version;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.mx.loading.LoaderRepositoryFactory;

public class LoaderRepositoryConfigHelper {
    public static ClassLoadingMetaData create(DeploymentUnit unit, LoaderRepositoryFactory.LoaderRepositoryConfig loaderConfig) throws DeploymentException {
        return LoaderRepositoryConfigHelper.create(unit, loaderConfig, false);
    }

    public static ClassLoadingMetaData create(DeploymentUnit unit, LoaderRepositoryFactory.LoaderRepositoryConfig loaderConfig, boolean parentDelegation) throws DeploymentException {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        ClassLoadingMetaData clmd = (ClassLoadingMetaData)unit.getAttachment(ClassLoadingMetaData.class);
        if (clmd != null) {
            return clmd;
        }
        clmd = LoaderRepositoryConfigHelper.create(unit.getName(), loaderConfig, parentDelegation);
        if (clmd != null) {
            unit.addAttachment(ClassLoadingMetaData.class, (Object)clmd);
        }
        return clmd;
    }

    public static ClassLoadingMetaData create(String deploymentName, LoaderRepositoryFactory.LoaderRepositoryConfig loaderConfig) throws DeploymentException {
        return LoaderRepositoryConfigHelper.create(deploymentName, loaderConfig, false);
    }

    public static ClassLoadingMetaData create(String deploymentName, LoaderRepositoryFactory.LoaderRepositoryConfig loaderConfig, boolean parentDelegation) throws DeploymentException {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Null deployment name");
        }
        if (loaderConfig == null) {
            throw new IllegalArgumentException("Null loader config");
        }
        ObjectName name = loaderConfig.repositoryName;
        if (name == null) {
            return null;
        }
        String domain = name.getCanonicalName().trim();
        if (domain.length() == 0) {
            return null;
        }
        ClassLoadingMetaData metaData = new ClassLoadingMetaData();
        metaData.setName(deploymentName);
        metaData.setDomain(domain);
        metaData.setExportAll(ExportAll.NON_EMPTY);
        metaData.setImportAll(true);
        metaData.setVersion((Object)Version.DEFAULT_VERSION);
        Properties props = new Properties();
        String config = loaderConfig.repositoryConfig;
        try {
            if (config != null) {
                ByteArrayInputStream bais = new ByteArrayInputStream(config.getBytes());
                props.load(bais);
            }
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Error parsing repository config " + config), (Throwable)e);
        }
        String java2ParentDelegation = props.getProperty("java2ParentDelegation");
        if (java2ParentDelegation == null) {
            java2ParentDelegation = props.getProperty("java2ParentDelegaton");
        }
        boolean useParentFirst = parentDelegation;
        if (java2ParentDelegation != null) {
            useParentFirst = Boolean.valueOf(java2ParentDelegation);
        }
        metaData.setJ2seClassLoadingCompliance(useParentFirst);
        return metaData;
    }
}

