/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.threads.ManagedScheduledExecutorService;
import org.jboss.as.threads.ThreadsMessages;
import org.jboss.as.threads.TimeSpec;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public final class ScheduledThreadPoolService
implements Service<ManagedScheduledExecutorService> {
    private final InjectedValue<ThreadFactory> threadFactoryValue = new InjectedValue();
    private ManagedScheduledExecutorService executor;
    private StopContext context;
    private final int maxThreads;
    private final TimeSpec keepAlive;

    public ScheduledThreadPoolService(int maxThreads, TimeSpec keepAlive) {
        this.maxThreads = maxThreads;
        this.keepAlive = keepAlive;
    }

    public synchronized void start(StartContext context) throws StartException {
        ExecutorImpl scheduledExecutor = new ExecutorImpl(0, (ThreadFactory)this.threadFactoryValue.getValue());
        scheduledExecutor.setCorePoolSize(this.maxThreads);
        if (this.keepAlive != null) {
            scheduledExecutor.setKeepAliveTime(this.keepAlive.getDuration(), this.keepAlive.getUnit());
        }
        this.executor = new ManagedScheduledExecutorService(scheduledExecutor);
    }

    public synchronized void stop(StopContext context) {
        ManagedScheduledExecutorService executor = this.getValue();
        this.context = context;
        context.asynchronous();
        executor.internalShutdown();
        this.executor = null;
    }

    public synchronized ManagedScheduledExecutorService getValue() throws IllegalStateException {
        ManagedScheduledExecutorService value = this.executor;
        if (value == null) {
            throw ThreadsMessages.MESSAGES.scheduledThreadPoolExecutorUninitialized();
        }
        return value;
    }

    public Injector<ThreadFactory> getThreadFactoryInjector() {
        return this.threadFactoryValue;
    }

    public int getActiveCount() {
        ManagedScheduledExecutorService executor = this.getValue();
        return executor.getActiveCount();
    }

    public long getCompletedTaskCount() {
        ManagedScheduledExecutorService executor = this.getValue();
        return executor.getCompletedTaskCount();
    }

    public int getCurrentThreadCount() {
        ManagedScheduledExecutorService executor = this.getValue();
        return executor.getPoolSize();
    }

    public int getLargestThreadCount() {
        ManagedScheduledExecutorService executor = this.getValue();
        return executor.getLargestPoolSize();
    }

    public long getTaskCount() {
        ManagedScheduledExecutorService executor = this.getValue();
        return executor.getTaskCount();
    }

    private class ExecutorImpl
    extends ScheduledThreadPoolExecutor {
        ExecutorImpl(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void terminated() {
            ScheduledThreadPoolService scheduledThreadPoolService = ScheduledThreadPoolService.this;
            synchronized (scheduledThreadPoolService) {
                super.terminated();
                ScheduledThreadPoolService.this.context.complete();
                ScheduledThreadPoolService.this.context = null;
            }
        }
    }
}

