/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.protocol.ProtocolLogger;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.ActiveOperationSupport;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.FlushableDataOutputImpl;
import org.jboss.as.protocol.mgmt.ManagementMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.threads.AsyncFuture;
import org.xnio.Cancellable;

public abstract class AbstractMessageHandler<T, A>
extends ActiveOperationSupport<T, A>
implements ManagementMessageHandler {
    private final ExecutorService executorService;
    private final AtomicInteger requestID = new AtomicInteger();
    private final Map<Integer, ActiveRequest> requests = Collections.synchronizedMap(new HashMap());

    protected AbstractMessageHandler(ExecutorService executorService) {
        super(executorService);
        if (executorService == null) {
            throw ProtocolMessages.MESSAGES.nullExecutor();
        }
        this.executorService = executorService;
    }

    protected ExecutorService getExecutor() {
        return this.executorService;
    }

    protected ManagementRequestHandler<T, A> getRequestHandler(byte operationType) {
        return this.getFallbackHandler();
    }

    protected ManagementRequestHeader validateRequest(ManagementProtocolHeader header) throws IOException {
        return (ManagementRequestHeader)header;
    }

    @Override
    public void handleMessage(Channel channel, DataInput input, ManagementProtocolHeader header) throws IOException {
        byte type = header.getType();
        if (type == 3) {
            ManagementResponseHeader response = (ManagementResponseHeader)header;
            ActiveRequest request = this.requests.remove(response.getResponseId());
            if (request == null) {
                ProtocolLogger.CONNECTION_LOGGER.noSuchRequest(response.getResponseId(), channel);
            } else if (response.getError() != null) {
                request.context.getResultHandler().failed(new IOException(response.getError()));
            } else {
                this.handleMessage(channel, input, header, request.context, request.handler);
            }
        } else {
            try {
                ManagementRequestHeader requestHeader = this.validateRequest(header);
                ActiveOperation support = this.getActiveOperation(requestHeader);
                if (support == null) {
                    AbstractMessageHandler.safeWriteErrorResponse(channel, header, ProtocolMessages.MESSAGES.responseHandlerNotFound(requestHeader.getBatchId()));
                    return;
                }
                ManagementRequestHandler<T, A> handler = this.getRequestHandler(requestHeader.getOperationId());
                if (handler == null) {
                    AbstractMessageHandler.safeWriteErrorResponse(channel, header, ProtocolMessages.MESSAGES.responseHandlerNotFound(requestHeader.getBatchId()));
                } else {
                    this.handleMessage(channel, input, requestHeader, support, handler);
                }
            }
            catch (Exception e) {
                AbstractMessageHandler.safeWriteErrorResponse(channel, header, e);
            }
        }
    }

    protected AsyncFuture<T> executeRequest(ManagementRequest<T, A> request, final Channel channel, final ActiveOperation<T, A> support) {
        assert (support != null);
        final Integer requestId = this.requestID.incrementAndGet();
        ActiveRequest ar = new ActiveRequest(support, request);
        this.requests.put(requestId, ar);
        final ManagementRequestHeader header = new ManagementRequestHeader(1, requestId, support.getOperationId(), request.getOperationType());
        final ActiveOperation.ResultHandler<T> resultHandler = support.getResultHandler();
        try {
            request.sendRequest(resultHandler, new ManagementRequestContext<A>(){

                @Override
                public Integer getOperationId() {
                    return support.getOperationId();
                }

                @Override
                public A getAttachment() {
                    return support.getAttachment();
                }

                @Override
                public Channel getChannel() {
                    return channel;
                }

                @Override
                public ManagementProtocolHeader getRequestHeader() {
                    return header;
                }

                private ExecutorService getExecutor() {
                    return AbstractMessageHandler.this.executorService;
                }

                @Override
                public void executeAsync(final ManagementRequestContext.AsyncTask<A> task) {
                    final 1 context = this;
                    AsyncTaskRunner runner = new AsyncTaskRunner(){

                        @Override
                        protected void doExecute() {
                            try {
                                task.execute(context);
                            }
                            catch (Exception e) {
                                resultHandler.failed(e);
                                AbstractMessageHandler.this.requests.remove(requestId);
                            }
                        }
                    };
                    support.addCancellable(runner);
                    this.getExecutor().execute(runner);
                }

                @Override
                public FlushableDataOutput writeMessage(ManagementProtocolHeader header2) throws IOException {
                    MessageOutputStream os = channel.writeMessage();
                    return AbstractMessageHandler.writeHeader(header2, (OutputStream)os);
                }
            });
            channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                public void handleClose(Channel closed, IOException e) {
                    if (channel == closed) {
                        IOException failure = e == null ? new IOException("Channel closed") : e;
                        resultHandler.failed(failure);
                    }
                }
            });
        }
        catch (Exception e) {
            resultHandler.failed(e);
        }
        return support.getResult();
    }

    protected void handleMessage(final Channel channel, DataInput message, final ManagementProtocolHeader header, final ActiveOperation<T, A> support, ManagementRequestHandler<T, A> handler) {
        assert (support != null);
        final ActiveOperation.ResultHandler<T> resultHandler = support.getResultHandler();
        try {
            handler.handleRequest(message, resultHandler, new ManagementRequestContext<A>(){

                @Override
                public Integer getOperationId() {
                    return support.getOperationId();
                }

                @Override
                public A getAttachment() {
                    return support.getAttachment();
                }

                @Override
                public Channel getChannel() {
                    return channel;
                }

                @Override
                public ManagementProtocolHeader getRequestHeader() {
                    return header;
                }

                private ExecutorService getExecutor() {
                    return AbstractMessageHandler.this.executorService;
                }

                @Override
                public void executeAsync(final ManagementRequestContext.AsyncTask<A> task) {
                    final 3 context = this;
                    AsyncTaskRunner runner = new AsyncTaskRunner(){

                        @Override
                        protected void doExecute() {
                            block2: {
                                try {
                                    task.execute(context);
                                }
                                catch (Exception e) {
                                    ProtocolLogger.ROOT_LOGGER.errorf(e, " failed to process async request for %s on channel %s", task, channel);
                                    if (!resultHandler.failed(e)) break block2;
                                    AbstractMessageHandler.safeWriteErrorResponse(channel, header, e);
                                }
                            }
                        }
                    };
                    support.addCancellable(runner);
                    this.getExecutor().execute(runner);
                }

                @Override
                public FlushableDataOutput writeMessage(ManagementProtocolHeader header2) throws IOException {
                    MessageOutputStream os = channel.writeMessage();
                    return AbstractMessageHandler.writeHeader(header2, (OutputStream)os);
                }
            });
        }
        catch (Exception e) {
            resultHandler.failed(e);
            AbstractMessageHandler.safeWriteErrorResponse(channel, header, e);
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.shutdown();
        this.cancelAllActiveOperations();
    }

    @Override
    public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        return super.awaitCompletion(timeout, unit);
    }

    protected static void safeWriteErrorResponse(Channel channel, ManagementProtocolHeader header, Exception error) {
        if (header.getType() == 2) {
            try {
                AbstractMessageHandler.writeErrorResponse(channel, (ManagementRequestHeader)header, error);
            }
            catch (IOException ioe) {
                ProtocolLogger.ROOT_LOGGER.tracef(ioe, "failed to write error response for %s on channel: %s", header, channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeErrorResponse(Channel channel, ManagementRequestHeader header, Exception error) throws IOException {
        ManagementResponseHeader response = ManagementResponseHeader.create(header, error);
        MessageOutputStream output = channel.writeMessage();
        try {
            AbstractMessageHandler.writeHeader(response, (OutputStream)output);
            output.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)output);
        }
    }

    protected static FlushableDataOutput writeHeader(ManagementProtocolHeader header, OutputStream os) throws IOException {
        FlushableDataOutput output = FlushableDataOutputImpl.create(os);
        header.write(output);
        return output;
    }

    protected ManagementRequestHandler<T, A> getFallbackHandler() {
        return new ManagementRequestHandler<T, A>(){

            @Override
            public void handleRequest(DataInput input, ActiveOperation.ResultHandler<T> resultHandler, ManagementRequestContext<A> context) throws IOException {
                IOException error = new IOException("no handler registered");
                if (resultHandler.failed(error)) {
                    AbstractMessageHandler.safeWriteErrorResponse(context.getChannel(), context.getRequestHeader(), error);
                }
            }
        };
    }

    private static abstract class AsyncTaskRunner
    implements Runnable,
    Cancellable {
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private volatile Thread thread;

        private AsyncTaskRunner() {
        }

        public Cancellable cancel() {
            Thread thread;
            if (this.cancelled.compareAndSet(false, true) && (thread = this.thread) != null) {
                thread.interrupt();
            }
            return this;
        }

        protected abstract void doExecute();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.cancelled.get()) {
                return;
            }
            this.thread = Thread.currentThread();
            try {
                this.doExecute();
            }
            finally {
                this.thread = null;
            }
        }
    }

    private class ActiveRequest {
        private final ActiveOperation<T, A> context;
        private final ManagementRequestHandler<T, A> handler;

        ActiveRequest(ActiveOperation<T, A> context, ManagementRequestHandler<T, A> handler) {
            this.context = context;
            this.handler = handler;
        }
    }
}

