/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.connections.ldap;

import java.util.Properties;
import javax.naming.directory.InitialDirContext;
import org.jboss.as.domain.management.connections.ConnectionManager;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class LdapConnectionManagerService
implements Service<LdapConnectionManagerService>,
ConnectionManager {
    public static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "controller", "management", "connection_manager"});
    private volatile ModelNode resolvedConfiguration;

    public LdapConnectionManagerService(ModelNode resolvedConfiguration) {
        this.setResolvedConfiguration(resolvedConfiguration);
    }

    void setResolvedConfiguration(ModelNode resolvedConfiguration) {
        resolvedConfiguration.require(LdapConnectionResourceDefinition.URL.getName());
        resolvedConfiguration.require(LdapConnectionResourceDefinition.SEARCH_DN.getName());
        resolvedConfiguration.require(LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.getName());
        resolvedConfiguration.require(LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.getName());
        this.resolvedConfiguration = resolvedConfiguration;
    }

    public synchronized void start(StartContext context) throws StartException {
    }

    public synchronized void stop(StopContext context) {
    }

    public synchronized LdapConnectionManagerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public Object getConnection() throws Exception {
        ModelNode config = this.resolvedConfiguration;
        return this.getConnection(this.getFullProperties(config));
    }

    @Override
    public Object getConnection(String principal, String credential) throws Exception {
        ModelNode config = this.resolvedConfiguration;
        Properties connectionProperties = this.getConnectionOnlyProperties(config);
        connectionProperties.put("java.naming.security.principal", principal);
        connectionProperties.put("java.naming.security.credentials", credential);
        return this.getConnection(connectionProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getConnection(Properties properties) throws Exception {
        ClassLoader original = null;
        try {
            original = Thread.currentThread().getContextClassLoader();
            if (original != null) {
                Thread.currentThread().setContextClassLoader(null);
            }
            InitialDirContext initialDirContext = new InitialDirContext(properties);
            return initialDirContext;
        }
        finally {
            if (original != null) {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
    }

    private Properties getConnectionOnlyProperties(ModelNode config) {
        Properties result = new Properties();
        String initialContextFactory = config.require("initial-context-factory").asString();
        result.put("java.naming.factory.initial", initialContextFactory);
        String url = config.require("url").asString();
        result.put("java.naming.provider.url", url);
        return result;
    }

    private Properties getFullProperties(ModelNode config) {
        Properties result = this.getConnectionOnlyProperties(config);
        String searchDN = config.require("search-dn").asString();
        String searchCredential = config.require("search-credential").asString();
        result.put("java.naming.security.principal", searchDN);
        result.put("java.naming.security.credentials", searchCredential);
        return result;
    }
}

