/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.descriptions.HostRootDescription;
import org.jboss.dmr.ModelNode;

public class HostShutdownHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "shutdown";
    private final DomainController domainController;

    public HostShutdownHandler(DomainController domainController) {
        this.domainController = domainController;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final boolean restart = operation.hasDefined("restart") ? operation.get("restart").asBoolean() : false;
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (restart) {
                    HostShutdownHandler.this.domainController.stopLocalHost(10);
                } else {
                    HostShutdownHandler.this.domainController.stopLocalHost();
                }
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return HostRootDescription.getHostShutdownHandler(locale);
    }
}

