/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.validation.AbstractParameterValidator;
import org.jboss.as.controller.operations.validation.ChainedParameterValidator;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersOfValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.repository.ContentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentAddHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    private static final List<String> CONTENT_ADDITION_PARAMETERS = Arrays.asList("input-stream-index", "bytes", "url");
    private final ContentRepository contentRepository;
    private final ParametersValidator validator = new ParametersValidator();
    private final ParametersValidator unmanagedContentValidator = new ParametersValidator();
    private final ParametersValidator managedContentValidator = new ParametersValidator();

    public DeploymentAddHandler() {
        this(null);
    }

    public DeploymentAddHandler(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
        this.validator.registerValidator("runtime-name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        ParametersValidator contentValidator = new ParametersValidator();
        contentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("archive", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true));
        contentValidator.registerValidator("path", (ParameterValidator)new StringLengthValidator(1, true));
        contentValidator.registerValidator("relative-to", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true));
        contentValidator.registerValidator("input-stream-index", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true));
        contentValidator.registerValidator("bytes", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("url", (ParameterValidator)new StringLengthValidator(1, true));
        this.validator.registerValidator("content", ChainedParameterValidator.chain((ParameterValidator[])new ParameterValidator[]{new ListValidator((ParameterValidator)new ParametersOfValidator(contentValidator)), new AbstractParameterValidator(){

            public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                DeploymentAddHandler.validateOnePieceOfContent(value);
            }
        }}));
        this.managedContentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES));
        this.unmanagedContentValidator.registerValidator("archive", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
        this.unmanagedContentValidator.registerValidator("path", (ParameterValidator)new StringLengthValidator(1));
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getAddDeploymentOperation((Locale)locale, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        String runtimeName = operation.hasDefined("runtime-name") ? operation.get("runtime-name").asString() : name;
        byte[] hash = null;
        ModelNode content = operation.require("content").clone();
        ModelNode contentItemNode = content.require(0);
        if (contentItemNode.hasDefined("hash")) {
            this.managedContentValidator.validate(contentItemNode);
            hash = contentItemNode.require("hash").asBytes();
            if (this.contentRepository != null && !this.contentRepository.hasContent(hash)) {
                if (!context.isBooting()) throw DeploymentAddHandler.createFailureException(DomainControllerMessages.MESSAGES.noDeploymentContentWithHash(HashUtil.bytesToHexString((byte[])hash)));
                if (context.getRunningMode() != RunningMode.ADMIN_ONLY) throw DeploymentAddHandler.createFailureException(DomainControllerMessages.MESSAGES.noDeploymentContentWithHashAtBoot(HashUtil.bytesToHexString((byte[])hash), name));
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.reportAdminOnlyMissingDeploymentContent(HashUtil.bytesToHexString((byte[])hash), name);
            }
        } else if (DeploymentAddHandler.hasValidContentAdditionParameterDefined(contentItemNode)) {
            if (this.contentRepository == null) {
                throw DeploymentAddHandler.createFailureException(DomainControllerMessages.MESSAGES.slaveCannotAcceptUploads());
            }
            InputStream in = DeploymentAddHandler.getInputStream(context, contentItemNode);
            try {
                try {
                    hash = this.contentRepository.addContent(in);
                }
                catch (IOException e) {
                    throw DeploymentAddHandler.createFailureException(e.toString());
                }
            }
            finally {
                StreamUtils.safeClose((Closeable)in);
            }
            contentItemNode.clear();
            contentItemNode.get("hash").set(hash);
        } else {
            this.unmanagedContentValidator.validate(contentItemNode);
        }
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode subModel = resource.getModel();
        subModel.get("name").set(name);
        subModel.get("runtime-name").set(runtimeName);
        subModel.get("content").set(content);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    private static InputStream getInputStream(OperationContext context, ModelNode operation) throws OperationFailedException {
        InputStream in = null;
        String message = "";
        if (operation.hasDefined("input-stream-index")) {
            int streamIndex = operation.get("input-stream-index").asInt();
            message = DomainControllerMessages.MESSAGES.nullStream(streamIndex);
            in = context.getAttachmentStream(streamIndex);
        } else if (operation.hasDefined("bytes")) {
            message = DomainControllerMessages.MESSAGES.invalidByteStream();
            in = new ByteArrayInputStream(operation.get("bytes").asBytes());
        } else if (operation.hasDefined("url")) {
            String urlSpec = operation.get("url").asString();
            try {
                message = DomainControllerMessages.MESSAGES.invalidUrlStream();
                in = new URL(urlSpec).openStream();
            }
            catch (MalformedURLException e) {
                throw DeploymentAddHandler.createFailureException(message);
            }
            catch (IOException e) {
                throw DeploymentAddHandler.createFailureException(message);
            }
        }
        if (in == null) {
            throw DeploymentAddHandler.createFailureException(message);
        }
        return in;
    }

    private static boolean hasValidContentAdditionParameterDefined(ModelNode operation) {
        for (String s : CONTENT_ADDITION_PARAMETERS) {
            if (!operation.hasDefined(s)) continue;
            return true;
        }
        return false;
    }

    private static OperationFailedException createFailureException(String msg) {
        return new OperationFailedException(msg);
    }

    private static void validateOnePieceOfContent(ModelNode content) throws OperationFailedException {
        if (content.asList().size() != 1) {
            throw DeploymentAddHandler.createFailureException(DomainControllerMessages.MESSAGES.as7431());
        }
    }
}

