/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.SecureRandom;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class AdditionalDataUUID
extends UUID {
    private static final long serialVersionUID = 4583682459482601554L;
    protected byte[] payload;

    public AdditionalDataUUID() {
    }

    protected AdditionalDataUUID(byte[] data, byte[] payload) {
        super(data);
        this.payload = payload;
    }

    public static AdditionalDataUUID randomUUID(byte[] payload) {
        return new AdditionalDataUUID(AdditionalDataUUID.generateRandomBytes(), payload);
    }

    public static AdditionalDataUUID randomUUID(String logical_name, byte[] payload) {
        AdditionalDataUUID retval = new AdditionalDataUUID(AdditionalDataUUID.generateRandomBytes(), payload);
        UUID.add(retval, logical_name);
        return retval;
    }

    protected static byte[] generateRandomBytes() {
        SecureRandom ng = numberGenerator;
        if (ng == null) {
            numberGenerator = ng = new SecureRandom();
        }
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        return randomBytes;
    }

    @Override
    public int size() {
        int retval = super.size() + 1;
        if (this.payload != null) {
            retval += this.payload.length;
        }
        return retval;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        try {
            Util.writeByteBuffer(this.payload, out);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        try {
            this.payload = Util.readByteBuffer(in);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        super.writeTo(out);
        Util.writeByteBuffer(this.payload, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        super.readFrom(in);
        this.payload = Util.readByteBuffer(in);
    }

    @Override
    public String toString() {
        if (print_uuids) {
            return this.toStringLong() + (this.payload == null ? "" : " (" + this.payload.length + " bytes)");
        }
        return super.toString() + (this.payload == null ? "" : " (" + this.payload.length + " bytes)");
    }
}

