/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf.transports;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.stack.IpAddress;
import org.jgroups.tests.perf.Transport;
import org.jgroups.tests.perf.transports.JGroupsTransport;

public class JGroupsClusterTransport
extends JGroupsTransport
implements Transport {
    List members;

    @Override
    public void create(Properties properties) throws Exception {
        super.create(properties);
        String cluster_def = this.config.getProperty("cluster");
        if (cluster_def == null) {
            throw new Exception("property 'cluster' is not defined");
        }
        this.members = this.parseCommaDelimitedList(cluster_def);
    }

    @Override
    public void send(Object destination, byte[] payload, boolean oob) throws Exception {
        if (destination != null) {
            Message msg = new Message((Address)destination, null, payload);
            if (oob) {
                msg.setFlag(Message.OOB);
            }
            this.channel.send(msg);
        } else {
            for (int i = 0; i < this.members.size(); ++i) {
                Address mbr = (Address)this.members.get(i);
                Message msg = new Message((Address)destination, null, payload);
                if (oob) {
                    msg.setFlag(Message.OOB);
                }
                msg.setDest(mbr);
                this.channel.send(msg);
            }
        }
    }

    private List parseCommaDelimitedList(String s) throws Exception {
        ArrayList<IpAddress> retval = new ArrayList<IpAddress>();
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            String tmp = tok.nextToken();
            int index = tmp.indexOf(58);
            if (index == -1) {
                throw new Exception("host must be in format <host:port>, was " + tmp);
            }
            String hostname = tmp.substring(0, index);
            int port = Integer.parseInt(tmp.substring(index + 1));
            IpAddress addr = new IpAddress(hostname, port);
            retval.add(addr);
        }
        return retval;
    }
}

