/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4;

import java.util.Map;
import java.util.Properties;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfigurationService;
import org.jboss.as.jpa.hibernate4.HibernateAnnotationScanner;
import org.jboss.as.jpa.hibernate4.JBossAppServerJtaPlatform;
import org.jboss.as.jpa.hibernate4.infinispan.SharedInfinispanRegionFactory;
import org.jboss.as.jpa.hibernate4.management.HibernateManagementAdaptor;
import org.jboss.as.jpa.spi.JtaManager;
import org.jboss.as.jpa.spi.ManagementAdaptor;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class HibernatePersistenceProviderAdaptor
implements PersistenceProviderAdaptor {
    private static final String DEFAULT_REGION_FACTORY = SharedInfinispanRegionFactory.class.getName();
    private volatile JBossAppServerJtaPlatform appServerJtaPlatform;

    public void injectJtaManager(JtaManager jtaManager) {
        this.appServerJtaPlatform = new JBossAppServerJtaPlatform(jtaManager);
    }

    public void addProviderProperties(Map properties, PersistenceUnitMetadata pu) {
        this.putPropertyIfAbsent(pu, properties, "hibernate.id.new_generator_mappings", "true");
        this.putPropertyIfAbsent(pu, properties, "hibernate.ejb.resource_scanner", HibernateAnnotationScanner.class.getName());
        properties.put("hibernate.classLoader.application", pu.getClassLoader());
        this.putPropertyIfAbsent(pu, properties, "hibernate.transaction.jta.platform", (Object)this.appServerJtaPlatform);
        properties.remove("hibernate.transaction.manager_lookup_class");
        this.putPropertyIfAbsent(pu, properties, "hibernate.ejb.entitymanager_factory_name", pu.getScopedPersistenceUnitName());
        this.putPropertyIfAbsent(pu, properties, "hibernate.session_factory_name", pu.getScopedPersistenceUnitName());
        if (!pu.getProperties().containsKey("hibernate.session_factory_name")) {
            this.putPropertyIfAbsent(pu, properties, "hibernate.session_factory_name_is_jndi", Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProviderDependencies(ServiceRegistry registry, ServiceTarget target, ServiceBuilder<?> builder, PersistenceUnitMetadata pu) {
        Properties properties = pu.getProperties();
        if (Boolean.parseBoolean(properties.getProperty("hibernate.cache.use_second_level_cache"))) {
            String regionFactory;
            if (properties.getProperty("hibernate.cache.region_prefix") == null) {
                properties.put("hibernate.cache.region_prefix", pu.getScopedPersistenceUnitName());
            }
            if ((regionFactory = properties.getProperty("hibernate.cache.region.factory_class")) == null) {
                regionFactory = DEFAULT_REGION_FACTORY;
                properties.setProperty("hibernate.cache.region.factory_class", regionFactory);
            }
            if (regionFactory.equals(DEFAULT_REGION_FACTORY)) {
                String container = properties.getProperty("hibernate.cache.infinispan.container");
                if (container == null) {
                    container = "hibernate";
                    properties.setProperty("hibernate.cache.infinispan.container", container);
                }
                ServiceName classLoaderServiceName = EmbeddedCacheManagerConfigurationService.getClassLoaderServiceName((String)container);
                HibernatePersistenceProviderAdaptor hibernatePersistenceProviderAdaptor = this;
                synchronized (hibernatePersistenceProviderAdaptor) {
                    if (registry.getService(classLoaderServiceName) == null) {
                        target.addService(classLoaderServiceName, (Service)new ValueService((Value)new ImmediateValue((Object)SharedInfinispanRegionFactory.class.getClassLoader()))).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                    }
                }
                String entity = properties.getProperty("hibernate.cache.infinispan.entity.cfg", "entity");
                String collection = properties.getProperty("hibernate.cache.infinispan.collection.cfg", "entity");
                String query = properties.getProperty("hibernate.cache.infinispan.query.cfg", "local-query");
                String timestamps = properties.getProperty("hibernate.cache.infinispan.timestamps.cfg", "local-query");
                builder.addDependency(CacheConfigurationService.getServiceName((String)container, (String)entity));
                builder.addDependency(CacheConfigurationService.getServiceName((String)container, (String)collection));
                builder.addDependency(CacheConfigurationService.getServiceName((String)container, (String)timestamps));
                builder.addDependency(CacheConfigurationService.getServiceName((String)container, (String)query));
            }
        }
    }

    private void putPropertyIfAbsent(PersistenceUnitMetadata pu, Map properties, String property, Object value) {
        if (!pu.getProperties().containsKey(property)) {
            properties.put(property, value);
        }
    }

    public void beforeCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        HibernateAnnotationScanner.setThreadLocalPersistenceUnitMetadata(pu);
    }

    public void afterCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        HibernateAnnotationScanner.clearThreadLocalPersistenceUnitMetadata();
    }

    public ManagementAdaptor getManagementAdaptor() {
        return HibernateManagementAdaptor.getInstance();
    }

    public void cleanup(PersistenceUnitMetadata pu) {
        HibernateAnnotationScanner.cleanup(pu);
    }
}

