/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.serviceref;

import java.net.URL;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.configuration.Configurer;
import org.jboss.ws.common.serviceref.AbstractServiceObjectFactoryJAXWS;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSSpringBusFactory;
import org.jboss.wsf.stack.cxf.client.serviceref.CXFHandlerResolverImpl;
import org.jboss.wsf.stack.cxf.client.serviceref.CXFServiceRefStubPropertyConfigurer;

public final class CXFServiceObjectFactoryJAXWS
extends AbstractServiceObjectFactoryJAXWS {
    private static final ThreadLocal<Bus> busAssociation = new ThreadLocal();

    protected void init(UnifiedServiceRefMetaData serviceRefUMDM) {
        BusFactory.setThreadDefaultBus(null);
        busAssociation.set(this.createNewBus(serviceRefUMDM));
    }

    protected void configure(UnifiedServiceRefMetaData serviceRefUMDM, Service service) {
        if (serviceRefUMDM.getHandlerChain() != null) {
            service.setHandlerResolver((HandlerResolver)new CXFHandlerResolverImpl(busAssociation.get(), serviceRefUMDM.getHandlerChain(), service.getClass()));
        }
    }

    protected void destroy(UnifiedServiceRefMetaData serviceRefUMDM) {
        busAssociation.set(null);
        BusFactory.setThreadDefaultBus(null);
    }

    private Bus createNewBus(UnifiedServiceRefMetaData serviceRefMD) {
        Bus bus;
        URL cxfConfig = this.getCXFConfiguration(serviceRefMD.getVfsRoot());
        if (cxfConfig != null) {
            JBossWSSpringBusFactory busFactory = new JBossWSSpringBusFactory();
            bus = busFactory.createBus(cxfConfig);
            BusFactory.setThreadDefaultBus((Bus)bus);
        } else {
            Bus threadBus = BusFactory.getThreadDefaultBus((boolean)false);
            bus = threadBus != null ? threadBus : BusFactory.newInstance().createBus();
        }
        Configurer configurer = (Configurer)bus.getExtension(Configurer.class);
        bus.setExtension((Object)new CXFServiceRefStubPropertyConfigurer(serviceRefMD, configurer), Configurer.class);
        return bus;
    }

    private URL getCXFConfiguration(UnifiedVirtualFile vfsRoot) {
        URL url = null;
        try {
            url = vfsRoot.findChild("WEB-INF/jbossws-cxf.xml").toURL();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url == null) {
            try {
                url = vfsRoot.findChild("META-INF/jbossws-cxf.xml").toURL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }
}

