/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.CriteriaTools;
import org.hibernate.envers.query.criteria.ExtendableCriterion;
import org.hibernate.envers.query.property.PropertyNameGetter;
import org.hibernate.envers.tools.query.Parameters;
import org.hibernate.envers.tools.query.QueryBuilder;

public class AggregatedAuditExpression
implements AuditCriterion,
ExtendableCriterion {
    private PropertyNameGetter propertyNameGetter;
    private AggregatedMode mode;
    private List<AuditCriterion> criterions;

    public AggregatedAuditExpression(PropertyNameGetter propertyNameGetter, AggregatedMode mode) {
        this.propertyNameGetter = propertyNameGetter;
        this.mode = mode;
        this.criterions = new ArrayList<AuditCriterion>();
    }

    @Override
    public AggregatedAuditExpression add(AuditCriterion criterion) {
        this.criterions.add(criterion);
        return this;
    }

    @Override
    public void addToQuery(AuditConfiguration auditCfg, String entityName, QueryBuilder qb, Parameters parameters) {
        String propertyName = this.propertyNameGetter.get(auditCfg);
        CriteriaTools.checkPropertyNotARelation(auditCfg, entityName, propertyName);
        QueryBuilder subQb = qb.newSubQueryBuilder();
        for (AuditCriterion versionsCriteria : this.criterions) {
            versionsCriteria.addToQuery(auditCfg, entityName, qb, parameters);
            versionsCriteria.addToQuery(auditCfg, entityName, subQb, subQb.getRootParameters());
        }
        switch (this.mode) {
            case MIN: {
                subQb.addProjection("min", propertyName, false);
                break;
            }
            case MAX: {
                subQb.addProjection("max", propertyName, false);
            }
        }
        parameters.addWhere(propertyName, "=", subQb);
    }

    public static enum AggregatedMode {
        MAX,
        MIN;

    }
}

