/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.envers.configuration.metadata.reader.ClassAuditingData;
import org.hibernate.envers.configuration.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.EnversMessageLogger;
import org.hibernate.envers.tools.MappingTools;
import org.hibernate.mapping.PersistentClass;
import org.jboss.logging.Logger;

public class ClassesAuditingData {
    public static final EnversMessageLogger LOG = (EnversMessageLogger)Logger.getMessageLogger(EnversMessageLogger.class, (String)ClassesAuditingData.class.getName());
    private final Map<String, ClassAuditingData> entityNameToAuditingData = new HashMap<String, ClassAuditingData>();
    private final Map<PersistentClass, ClassAuditingData> persistentClassToAuditingData = new LinkedHashMap<PersistentClass, ClassAuditingData>();

    public void addClassAuditingData(PersistentClass pc, ClassAuditingData cad) {
        this.entityNameToAuditingData.put(pc.getEntityName(), cad);
        this.persistentClassToAuditingData.put(pc, cad);
    }

    public Collection<Map.Entry<PersistentClass, ClassAuditingData>> getAllClassAuditedData() {
        return this.persistentClassToAuditingData.entrySet();
    }

    public ClassAuditingData getClassAuditingData(String entityName) {
        return this.entityNameToAuditingData.get(entityName);
    }

    public void updateCalculatedFields() {
        for (Map.Entry<PersistentClass, ClassAuditingData> classAuditingDataEntry : this.persistentClassToAuditingData.entrySet()) {
            PersistentClass pc = classAuditingDataEntry.getKey();
            ClassAuditingData classAuditingData = classAuditingDataEntry.getValue();
            for (String propertyName : classAuditingData.getPropertyNames()) {
                PropertyAuditingData propertyAuditingData = classAuditingData.getPropertyAuditingData(propertyName);
                if (propertyAuditingData.getAuditMappedBy() == null) continue;
                String referencedEntityName = MappingTools.getReferencedEntityName(pc.getProperty(propertyName).getValue());
                ClassAuditingData referencedClassAuditingData = this.entityNameToAuditingData.get(referencedEntityName);
                this.forcePropertyInsertable(referencedClassAuditingData, propertyAuditingData.getAuditMappedBy(), pc.getEntityName(), referencedEntityName);
                this.forcePropertyInsertable(referencedClassAuditingData, propertyAuditingData.getPositionMappedBy(), pc.getEntityName(), referencedEntityName);
            }
        }
    }

    private void forcePropertyInsertable(ClassAuditingData classAuditingData, String propertyName, String entityName, String referencedEntityName) {
        if (propertyName != null) {
            if (classAuditingData.getPropertyAuditingData(propertyName) == null) {
                throw new MappingException("@AuditMappedBy points to a property that doesn't exist: " + referencedEntityName + "." + propertyName);
            }
            LOG.debugf("Non-insertable property %s.%s will be made insertable because a matching @AuditMappedBy was found in the %s entity", referencedEntityName, propertyName, entityName);
            classAuditingData.getPropertyAuditingData(propertyName).setForceInsertable(true);
        }
    }
}

