/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.Map;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XVersionRange;
import org.jboss.osgi.resolver.spi.AbstractModule;
import org.jboss.osgi.resolver.spi.AbstractRequirement;
import org.osgi.framework.Version;

public class AbstractPackageRequirement
extends AbstractRequirement
implements XPackageRequirement {
    private XVersionRange versionRange = XVersionRange.infiniteRange;
    private String resolution;

    public AbstractPackageRequirement(AbstractModule module, String name, Map<String, String> dirs, Map<String, Object> atts) {
        super(module, name, dirs, atts);
        String dir = this.getDirective("resolution");
        this.resolution = dir != null ? dir : "mandatory";
        this.setOptional(this.resolution.equals("optional"));
        Object att = this.getAttribute("version");
        if (att != null) {
            this.versionRange = XVersionRange.parse((String)att.toString());
        }
    }

    public String getResolution() {
        return this.resolution;
    }

    public XVersionRange getVersionRange() {
        return this.versionRange;
    }

    public String getBundleSymbolicName() {
        return (String)this.getAttribute("bundle-symbolic-name");
    }

    public Version getBundleVersion() {
        Object att = this.getAttribute("bundle-version");
        return att != null ? Version.parseVersion((String)att.toString()) : null;
    }

    public boolean match(XPackageCapability cap) {
        if (!this.matchPackageName(cap)) {
            return false;
        }
        if (!this.matchPackageVersion(cap)) {
            return false;
        }
        boolean validMatch = true;
        for (Map.Entry entry : this.getAttributes().entrySet()) {
            String key = (String)entry.getKey();
            String reqValue = (String)entry.getValue();
            if ("version".equals(key) || "specification-version".equals(key)) continue;
            if ("bundle-symbolic-name".equals(key)) {
                String capModuleName = cap.getModule().getName();
                if (reqValue.equals(capModuleName)) continue;
                validMatch = false;
                break;
            }
            String capValue = (String)cap.getAttribute(key);
            if (reqValue.equals(capValue)) continue;
            validMatch = false;
            break;
        }
        return validMatch;
    }

    public boolean matchPackageName(XPackageCapability cap) {
        return this.getName().equals(cap.getName());
    }

    private boolean matchPackageVersion(XPackageCapability cap) {
        return this.getVersionRange().isInRange(cap.getVersion());
    }

    public String toString() {
        return "Import-Package[" + this.getName() + ":" + this.versionRange + ";resolution:=" + this.resolution + "]";
    }
}

