/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.util.collection.ConcurrentNavigableMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentSkipListMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentNavigableMap<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -8627078645895051609L;
    private static final Object BASE_HEADER = new Object();
    volatile transient HeadIndex<K, V> head;
    private final Comparator<? super K> comparator;
    private transient int randomSeed;
    private transient KeySet keySet;
    private transient EntrySet entrySet;
    private transient Values values;
    private transient DescendingKeySet descendingKeySet;
    private transient DescendingEntrySet descendingEntrySet;
    private static final AtomicReferenceFieldUpdater<ConcurrentSkipListMap, HeadIndex> headUpdater = AccessController.doPrivileged(new PrivilegedAction<AtomicReferenceFieldUpdater<ConcurrentSkipListMap, HeadIndex>>(){

        @Override
        public AtomicReferenceFieldUpdater<ConcurrentSkipListMap, HeadIndex> run() {
            return AtomicReferenceFieldUpdater.newUpdater(ConcurrentSkipListMap.class, HeadIndex.class, "head");
        }
    });
    private static final int EQ = 1;
    private static final int LT = 2;
    private static final int GT = 0;

    final void initialize() {
        this.keySet = null;
        this.entrySet = null;
        this.values = null;
        this.descendingEntrySet = null;
        this.descendingKeySet = null;
        this.randomSeed = (int)System.nanoTime();
        this.head = new HeadIndex(new Node(null, BASE_HEADER, null), null, null, 1);
    }

    private boolean casHead(HeadIndex<K, V> cmp, HeadIndex<K, V> val) {
        return headUpdater.compareAndSet(this, cmp, val);
    }

    private Comparable<K> comparable(Object key) throws ClassCastException {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.comparator != null ? new ComparableUsingComparator<K>(key, this.comparator) : (Comparable)key;
    }

    int compare(K k1, K k2) throws ClassCastException {
        Comparator<K> cmp = this.comparator;
        if (cmp != null) {
            return cmp.compare(k1, k2);
        }
        return ((Comparable)k1).compareTo(k2);
    }

    boolean inHalfOpenRange(K key, K least, K fence) {
        if (key == null) {
            throw new NullPointerException();
        }
        return !(least != null && this.compare(key, least) < 0 || fence != null && this.compare(key, fence) >= 0);
    }

    boolean inOpenRange(K key, K least, K fence) {
        if (key == null) {
            throw new NullPointerException();
        }
        return !(least != null && this.compare(key, least) < 0 || fence != null && this.compare(key, fence) > 0);
    }

    private Node<K, V> findPredecessor(Comparable<K> key) {
        Index q;
        block0: while (true) {
            q = this.head;
            while (true) {
                Index d;
                Index r;
                if ((r = q.right) != null) {
                    if (r.indexesDeletedNode()) {
                        if (!q.unlink(r)) continue block0;
                        continue;
                    }
                    if (key.compareTo(r.key) > 0) {
                        q = r;
                        continue;
                    }
                }
                if ((d = q.down) == null) break block0;
                q = d;
            }
            break;
        }
        return q.node;
    }

    /*
     * Unable to fully structure code
     */
    private Node<K, V> findNode(Comparable<K> key) {
        block0: while (true) {
            b = this.findPredecessor(key);
            n = b.next;
            while (true) {
                if (n == null) {
                    return null;
                }
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v != n && b.value != null) ** break;
                continue block0;
                c = key.compareTo(n.key);
                if (c < 0) {
                    return null;
                }
                if (c == 0) {
                    return n;
                }
                b = n;
                n = f;
            }
            break;
        }
    }

    private V doGet(Object okey) {
        Comparable<K> key = this.comparable(okey);
        Object bound = null;
        Index q = this.head;
        while (true) {
            Index d;
            Object rk;
            Index r;
            if ((r = q.right) != null && (rk = r.key) != null && rk != bound) {
                int c = key.compareTo(rk);
                if (c > 0) {
                    q = r;
                    continue;
                }
                if (c == 0) {
                    Object v = r.node.value;
                    return (V)(v != null ? v : this.getUsingFindNode(key));
                }
                bound = rk;
            }
            if ((d = q.down) == null) break;
            q = d;
        }
        Node n = q.node.next;
        while (n != null) {
            Object nk = n.key;
            if (nk != null) {
                int c = key.compareTo(nk);
                if (c == 0) {
                    Object v = n.value;
                    return (V)(v != null ? v : this.getUsingFindNode(key));
                }
                if (c < 0) {
                    return null;
                }
            }
            n = n.next;
        }
        return null;
    }

    private V getUsingFindNode(Comparable<K> key) {
        Node<K, V> n;
        Object v;
        do {
            if ((n = this.findNode(key)) != null) continue;
            return null;
        } while ((v = n.value) == null);
        return (V)v;
    }

    private V doPut(K kkey, V value, boolean onlyIfAbsent) {
        Node z;
        Comparable<K> key = this.comparable(kkey);
        block0: while (true) {
            Node b = this.findPredecessor(key);
            Node n = b.next;
            while (n != null) {
                Node f = n.next;
                if (n != b.next) continue block0;
                Object v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v == n || b.value == null) continue block0;
                int c = key.compareTo(n.key);
                if (c > 0) {
                    b = n;
                    n = f;
                    continue;
                }
                if (c != 0) break;
                if (!onlyIfAbsent && !n.casValue(v, value)) continue block0;
                return (V)v;
            }
            if (b.casNext(n, z = new Node(kkey, value, n))) break;
        }
        int level = this.randomLevel();
        if (level > 0) {
            this.insertIndex(z, level);
        }
        return null;
    }

    private int randomLevel() {
        int level = 0;
        int r = this.randomSeed;
        this.randomSeed = r * 134775813 + 1;
        if (r < 0) {
            while ((r <<= 1) > 0) {
                ++level;
            }
        }
        return level;
    }

    private void insertIndex(Node<K, V> z, int level) {
        HeadIndex<K, V> h = this.head;
        int max = h.level;
        if (level <= max) {
            Index<K, V> idx = null;
            for (int i = 1; i <= level; ++i) {
                idx = new Index<K, V>(z, idx, null);
            }
            this.addIndex(idx, h, level);
        } else {
            int k;
            HeadIndex<K, V> oldh;
            Index[] idxs;
            block7: {
                int oldLevel;
                HeadIndex<K, V> newh;
                level = max + 1;
                idxs = new Index[level + 1];
                Index<K, V> idx = null;
                for (int i = 1; i <= level; ++i) {
                    idxs[i] = idx = new Index<K, V>(z, idx, null);
                }
                do {
                    oldh = this.head;
                    oldLevel = oldh.level;
                    if (level <= oldLevel) {
                        k = level;
                        break block7;
                    }
                    newh = oldh;
                    Node oldbase = oldh.node;
                    for (int j = oldLevel + 1; j <= level; ++j) {
                        newh = new HeadIndex<K, V>(oldbase, newh, idxs[j], j);
                    }
                } while (!this.casHead(oldh, newh));
                k = oldLevel;
            }
            this.addIndex(idxs[k], oldh, k);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void addIndex(Index<K, V> idx, HeadIndex<K, V> h, int indexLevel) {
        insertionLevel = indexLevel;
        key = this.comparable(idx.key);
        block0: while (true) {
            q /* !! */  = h;
            t = idx;
            j = h.level;
            while (true) {
                if ((r = q /* !! */ .right) != null) {
                    c = key.compareTo(r.key);
                    if (r.indexesDeletedNode()) {
                        if (!q /* !! */ .unlink(r)) continue block0;
                        continue;
                    }
                    if (c > 0) {
                        q /* !! */  = r;
                        continue;
                    }
                }
                if (j == insertionLevel) {
                    if (t.indexesDeletedNode()) {
                        this.findNode(key);
                        return;
                    }
                    if (q /* !! */ .link(r, t)) ** break;
                    continue block0;
                    if (--insertionLevel == 0) {
                        if (t.indexesDeletedNode()) {
                            this.findNode(key);
                        }
                        return;
                    }
                }
                if (j > insertionLevel && j <= indexLevel) {
                    t = t.down;
                }
                q /* !! */  = q /* !! */ .down;
                --j;
            }
            break;
        }
    }

    private V doRemove(Object okey, Object value) {
        Object v;
        Node f;
        Node n;
        Node b;
        Comparable<K> key = this.comparable(okey);
        block0: while (true) {
            b = this.findPredecessor(key);
            n = b.next;
            while (true) {
                if (n == null) {
                    return null;
                }
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v == n || b.value == null) continue block0;
                int c = key.compareTo(n.key);
                if (c < 0) {
                    return null;
                }
                if (c <= 0) break;
                b = n;
                n = f;
            }
            if (value != null && !value.equals(v)) {
                return null;
            }
            if (n.casValue(v, null)) break;
        }
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findNode(key);
        } else {
            this.findPredecessor(key);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        return (V)v;
    }

    private void tryReduceLevel() {
        HeadIndex e;
        HeadIndex d;
        HeadIndex<K, V> h = this.head;
        if (h.level > 3 && (d = (HeadIndex)h.down) != null && (e = (HeadIndex)d.down) != null && e.right == null && d.right == null && h.right == null && this.casHead(h, d) && h.right != null) {
            this.casHead(d, h);
        }
    }

    boolean removep(Object key) {
        return this.doRemove(key, null) != null;
    }

    Node<K, V> findFirst() {
        while (true) {
            Node b = this.head.node;
            Node n = b.next;
            if (n == null) {
                return null;
            }
            if (n.value != null) {
                return n;
            }
            n.helpDelete(b, n.next);
        }
    }

    Object doRemoveFirst(boolean keyOnly) {
        Object v;
        Node f;
        Node n;
        Node b;
        while (true) {
            b = this.head.node;
            n = b.next;
            if (n == null) {
                return null;
            }
            f = n.next;
            if (n != b.next) continue;
            v = n.value;
            if (v == null) {
                n.helpDelete(b, f);
                continue;
            }
            if (n.casValue(v, null)) break;
        }
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findFirst();
        }
        this.clearIndexToFirst();
        Object key = n.key;
        return keyOnly ? key : new SnapshotEntry(key, v);
    }

    private void clearIndexToFirst() {
        block0: while (true) {
            Index q = this.head;
            do {
                Index r;
                if ((r = q.right) != null && r.indexesDeletedNode() && !q.unlink(r)) continue block0;
            } while ((q = q.down) != null);
            break;
        }
        if (this.head.right == null) {
            this.tryReduceLevel();
        }
    }

    K pollFirstKey() {
        return (K)this.doRemoveFirst(true);
    }

    Node<K, V> findLast() {
        Index q = this.head;
        while (true) {
            Index r;
            if ((r = q.right) != null) {
                if (r.indexesDeletedNode()) {
                    q.unlink(r);
                    q = this.head;
                    continue;
                }
                q = r;
                continue;
            }
            Index d = q.down;
            if (d != null) {
                q = d;
                continue;
            }
            Node b = q.node;
            Node n = b.next;
            while (true) {
                if (n == null) {
                    return b.isBaseHeader() ? null : b;
                }
                Node f = n.next;
                if (n != b.next) break;
                Object v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    break;
                }
                if (v == n || b.value == null) break;
                b = n;
                n = f;
            }
            q = this.head;
        }
    }

    Object doRemoveLast(boolean keyOnly) {
        Object v;
        Node f;
        Node n;
        Node b;
        block0: while (true) {
            b = this.findPredecessorOfLast();
            n = b.next;
            if (n == null) {
                if (!b.isBaseHeader()) continue;
                return null;
            }
            while (true) {
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v == n || b.value == null) continue block0;
                if (f == null) break;
                b = n;
                n = f;
            }
            if (n.casValue(v, null)) break;
        }
        Object key = n.key;
        Comparable<K> ck = this.comparable(key);
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findNode(ck);
        } else {
            this.findPredecessor(ck);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        return keyOnly ? key : new SnapshotEntry(key, v);
    }

    private Node<K, V> findPredecessorOfLast() {
        Index q;
        block0: while (true) {
            q = this.head;
            while (true) {
                Index d;
                Index r;
                if ((r = q.right) != null) {
                    if (r.indexesDeletedNode()) {
                        q.unlink(r);
                        continue block0;
                    }
                    if (r.node.next != null) {
                        q = r;
                        continue;
                    }
                }
                if ((d = q.down) == null) break block0;
                q = d;
            }
            break;
        }
        return q.node;
    }

    K pollLastKey() {
        return (K)this.doRemoveLast(true);
    }

    /*
     * Unable to fully structure code
     */
    Node<K, V> findNear(K kkey, int rel) {
        key = this.comparable(kkey);
        block0: while (true) {
            b = this.findPredecessor(key);
            n = b.next;
            while (true) {
                if (n == null) {
                    return (rel & 2) == 0 || b.isBaseHeader() != false ? null : b;
                }
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v != n && b.value != null) ** break;
                continue block0;
                c = key.compareTo(n.key);
                if (c == 0 && (rel & 1) != 0 || c < 0 && (rel & 2) == 0) {
                    return n;
                }
                if (c <= 0 && (rel & 2) != 0) {
                    return b.isBaseHeader() != false ? null : b;
                }
                b = n;
                n = f;
            }
            break;
        }
    }

    SnapshotEntry<K, V> getNear(K kkey, int rel) {
        Node<K, V> n;
        SnapshotEntry<K, V> e;
        do {
            if ((n = this.findNear(kkey, rel)) != null) continue;
            return null;
        } while ((e = n.createSnapshot()) == null);
        return e;
    }

    Node<K, V> findCeiling(K key) {
        return key == null ? this.findFirst() : this.findNear(key, 1);
    }

    Node<K, V> findLower(K key) {
        return key == null ? this.findLast() : this.findNear(key, 2);
    }

    Object getNear(K kkey, int rel, K least, K fence, boolean keyOnly) {
        Object k;
        Node<K, V> n;
        V v;
        K key = kkey;
        if ((rel & 2) == 0 && this.compare(key, least) < 0) {
            key = least;
            rel |= 1;
        }
        do {
            if ((n = this.findNear(key, rel)) == null || !this.inHalfOpenRange(n.key, least, fence)) {
                return null;
            }
            k = n.key;
        } while ((v = n.getValidValue()) == null);
        return keyOnly ? k : new SnapshotEntry(k, v);
    }

    Object removeFirstEntryOfSubrange(K least, K fence, boolean keyOnly) {
        Object k;
        V v;
        do {
            Node<K, V> n;
            if ((n = this.findCeiling(least)) == null) {
                return null;
            }
            k = n.key;
            if (fence == null || this.compare(k, fence) < 0) continue;
            return null;
        } while ((v = this.doRemove(k, null)) == null);
        return keyOnly ? k : new SnapshotEntry(k, v);
    }

    Object removeLastEntryOfSubrange(K least, K fence, boolean keyOnly) {
        Object k;
        V v;
        do {
            Node<K, V> n;
            if ((n = this.findLower(fence)) == null) {
                return null;
            }
            k = n.key;
            if (least == null || this.compare(k, least) >= 0) continue;
            return null;
        } while ((v = this.doRemove(k, null)) == null);
        return keyOnly ? k : new SnapshotEntry(k, v);
    }

    public ConcurrentSkipListMap() {
        this.comparator = null;
        this.initialize();
    }

    public ConcurrentSkipListMap(Comparator<? super K> c) {
        this.comparator = c;
        this.initialize();
    }

    public ConcurrentSkipListMap(Map<? extends K, ? extends V> m) {
        this.comparator = null;
        this.initialize();
        this.putAll(m);
    }

    public ConcurrentSkipListMap(SortedMap<K, ? extends V> m) {
        this.comparator = m.comparator();
        this.initialize();
        this.buildFromSorted(m);
    }

    @Override
    public Object clone() {
        ConcurrentSkipListMap clone = null;
        try {
            clone = (ConcurrentSkipListMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.initialize();
        clone.buildFromSorted(this);
        return clone;
    }

    private void buildFromSorted(SortedMap<K, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        HeadIndex<K, V> h = this.head;
        Node basepred = h.node;
        ArrayList preds = new ArrayList();
        for (int i = 0; i <= h.level; ++i) {
            preds.add(null);
        }
        Index q = h;
        for (int i = h.level; i > 0; --i) {
            preds.set(i, q);
            q = q.down;
        }
        for (Map.Entry<K, V> e : map.entrySet()) {
            int j = this.randomLevel();
            if (j > h.level) {
                j = h.level + 1;
            }
            K k = e.getKey();
            V v = e.getValue();
            if (k == null || v == null) {
                throw new NullPointerException();
            }
            Node z = new Node(k, v, null);
            basepred.next = z;
            basepred = z;
            if (j <= 0) continue;
            Index idx = null;
            for (int i = 1; i <= j; ++i) {
                idx = new Index(z, idx, null);
                if (i > h.level) {
                    h = new HeadIndex<K, V>(h.node, h, idx, i);
                }
                if (i < preds.size()) {
                    ((Index)preds.get((int)i)).right = idx;
                    preds.set(i, idx);
                    continue;
                }
                preds.add(idx);
            }
        }
        this.head = h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Node<K, V> n = this.findFirst();
        while (n != null) {
            V v = n.getValidValue();
            if (v != null) {
                s.writeObject(n.key);
                s.writeObject(v);
            }
            n = n.next;
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object k;
        s.defaultReadObject();
        this.initialize();
        HeadIndex<Object, V> h = this.head;
        Node basepred = h.node;
        ArrayList preds = new ArrayList();
        for (int i = 0; i <= h.level; ++i) {
            preds.add(null);
        }
        Index q = h;
        for (int i = h.level; i > 0; --i) {
            preds.set(i, q);
            q = q.down;
        }
        while ((k = s.readObject()) != null) {
            Object v = s.readObject();
            if (v == null) {
                throw new NullPointerException();
            }
            Object key = k;
            Object val = v;
            int j = this.randomLevel();
            if (j > h.level) {
                j = h.level + 1;
            }
            Node z = new Node(key, val, null);
            basepred.next = z;
            basepred = z;
            if (j <= 0) continue;
            Index idx = null;
            for (int i = 1; i <= j; ++i) {
                idx = new Index(z, idx, null);
                if (i > h.level) {
                    h = new HeadIndex<Object, V>(h.node, h, idx, i);
                }
                if (i < preds.size()) {
                    ((Index)preds.get((int)i)).right = idx;
                    preds.set(i, idx);
                    continue;
                }
                preds.add(idx);
            }
        }
        this.head = h;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.doGet(key) != null;
    }

    @Override
    public V get(Object key) {
        return this.doGet(key);
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.doPut(key, value, false);
    }

    @Override
    public V remove(Object key) {
        return this.doRemove(key, null);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Node<K, V> n = this.findFirst();
        while (n != null) {
            V v = n.getValidValue();
            if (v != null && value.equals(v)) {
                return true;
            }
            n = n.next;
        }
        return false;
    }

    @Override
    public int size() {
        long count = 0L;
        Node<K, V> n = this.findFirst();
        while (n != null) {
            if (n.getValidValue() != null) {
                ++count;
            }
            n = n.next;
        }
        return count >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
    }

    @Override
    public boolean isEmpty() {
        return this.findFirst() == null;
    }

    @Override
    public void clear() {
        this.initialize();
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Set<K> descendingKeySet() {
        DescendingKeySet ks = this.descendingKeySet;
        return ks != null ? ks : (this.descendingKeySet = new DescendingKeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    @Override
    public Set<Map.Entry<K, V>> descendingEntrySet() {
        DescendingEntrySet es = this.descendingEntrySet;
        return es != null ? es : (this.descendingEntrySet = new DescendingEntrySet());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map t = (Map)o;
        try {
            return ConcurrentSkipListMap.containsAllMappings(this, t) && ConcurrentSkipListMap.containsAllMappings(t, this);
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    static <K, V> boolean containsAllMappings(Map<K, V> a, Map<K, V> b) {
        for (Map.Entry<K, V> e : b.entrySet()) {
            K k = e.getKey();
            V v = e.getValue();
            if (k != null && v != null && v.equals(a.get(k))) continue;
            return false;
        }
        return true;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.doPut(key, value, true);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.doRemove(key, value) != null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        Comparable<K> k = this.comparable(key);
        while (true) {
            Node<K, V> n;
            if ((n = this.findNode(k)) == null) {
                return false;
            }
            Object v = n.value;
            if (v == null) continue;
            if (!oldValue.equals(v)) {
                return false;
            }
            if (n.casValue(v, newValue)) break;
        }
        return true;
    }

    @Override
    public V replace(K key, V value) {
        Node<K, V> n;
        Object v;
        if (value == null) {
            throw new NullPointerException();
        }
        Comparable<K> k = this.comparable(key);
        do {
            if ((n = this.findNode(k)) != null) continue;
            return null;
        } while ((v = n.value) == null || !n.casValue(v, value));
        return (V)v;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public K firstKey() {
        Node<K, V> n = this.findFirst();
        if (n == null) {
            throw new NoSuchElementException();
        }
        return n.key;
    }

    @Override
    public K lastKey() {
        Node<K, V> n = this.findLast();
        if (n == null) {
            throw new NoSuchElementException();
        }
        return n.key;
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, K toKey) {
        if (fromKey == null || toKey == null) {
            throw new NullPointerException();
        }
        return new ConcurrentSkipListSubMap(this, fromKey, toKey);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey) {
        if (toKey == null) {
            throw new NullPointerException();
        }
        return new ConcurrentSkipListSubMap(this, null, toKey);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey) {
        if (fromKey == null) {
            throw new NullPointerException();
        }
        return new ConcurrentSkipListSubMap(this, fromKey, null);
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.getNear(key, 1);
    }

    @Override
    public K ceilingKey(K key) {
        Node<K, V> n = this.findNear(key, 1);
        return n == null ? null : (K)n.key;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.getNear(key, 2);
    }

    @Override
    public K lowerKey(K key) {
        Node<K, V> n = this.findNear(key, 2);
        return n == null ? null : (K)n.key;
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return this.getNear(key, 3);
    }

    @Override
    public K floorKey(K key) {
        Node<K, V> n = this.findNear(key, 3);
        return n == null ? null : (K)n.key;
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return this.getNear(key, 0);
    }

    @Override
    public K higherKey(K key) {
        Node<K, V> n = this.findNear(key, 0);
        return n == null ? null : (K)n.key;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        Node<K, V> n;
        SnapshotEntry<K, V> e;
        do {
            if ((n = this.findFirst()) != null) continue;
            return null;
        } while ((e = n.createSnapshot()) == null);
        return e;
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        Node<K, V> n;
        SnapshotEntry<K, V> e;
        do {
            if ((n = this.findLast()) != null) continue;
            return null;
        } while ((e = n.createSnapshot()) == null);
        return e;
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        return (SnapshotEntry)this.doRemoveFirst(false);
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return (SnapshotEntry)this.doRemoveLast(false);
    }

    Iterator<K> keyIterator() {
        return new KeyIterator();
    }

    Iterator<K> descendingKeyIterator() {
        return new DescendingKeyIterator();
    }

    SubMapEntryIterator subMapEntryIterator(K least, K fence) {
        return new SubMapEntryIterator(least, fence);
    }

    DescendingSubMapEntryIterator descendingSubMapEntryIterator(K least, K fence) {
        return new DescendingSubMapEntryIterator(least, fence);
    }

    SubMapKeyIterator subMapKeyIterator(K least, K fence) {
        return new SubMapKeyIterator(least, fence);
    }

    DescendingSubMapKeyIterator descendingSubMapKeyIterator(K least, K fence) {
        return new DescendingSubMapKeyIterator(least, fence);
    }

    SubMapValueIterator subMapValueIterator(K least, K fence) {
        return new SubMapValueIterator(least, fence);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConcurrentSkipListSubMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentNavigableMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -7647078645895051609L;
        private final ConcurrentSkipListMap<K, V> m;
        private final K least;
        private final K fence;
        private transient Set<K> keySetView;
        private transient Set<Map.Entry<K, V>> entrySetView;
        private transient Collection<V> valuesView;
        private transient Set<K> descendingKeySetView;
        private transient Set<Map.Entry<K, V>> descendingEntrySetView;

        ConcurrentSkipListSubMap(ConcurrentSkipListMap<K, V> map, K least, K fence) {
            if (least != null && fence != null && map.compare(least, fence) > 0) {
                throw new IllegalArgumentException("inconsistent range");
            }
            this.m = map;
            this.least = least;
            this.fence = fence;
        }

        boolean inHalfOpenRange(K key) {
            return this.m.inHalfOpenRange(key, this.least, this.fence);
        }

        boolean inOpenRange(K key) {
            return this.m.inOpenRange(key, this.least, this.fence);
        }

        Node<K, V> firstNode() {
            return this.m.findCeiling(this.least);
        }

        Node<K, V> lastNode() {
            return this.m.findLower(this.fence);
        }

        boolean isBeforeEnd(Node<K, V> n) {
            return n != null && (this.fence == null || n.key == null || this.m.compare(this.fence, n.key) > 0);
        }

        void checkKey(K key) throws IllegalArgumentException {
            if (!this.inHalfOpenRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
        }

        ConcurrentSkipListMap<K, V> getMap() {
            return this.m;
        }

        K getLeast() {
            return this.least;
        }

        K getFence() {
            return this.fence;
        }

        @Override
        public boolean containsKey(Object key) {
            Object k = key;
            return this.inHalfOpenRange(k) && this.m.containsKey(k);
        }

        @Override
        public V get(Object key) {
            Object k = key;
            return !this.inHalfOpenRange(k) ? null : (V)this.m.get(k);
        }

        @Override
        public V put(K key, V value) {
            this.checkKey(key);
            return this.m.put(key, value);
        }

        @Override
        public V remove(Object key) {
            Object k = key;
            return !this.inHalfOpenRange(k) ? null : (V)this.m.remove(k);
        }

        @Override
        public int size() {
            long count = 0L;
            Node<K, V> n = this.firstNode();
            while (this.isBeforeEnd(n)) {
                if (n.getValidValue() != null) {
                    ++count;
                }
                n = n.next;
            }
            return count >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
        }

        @Override
        public boolean isEmpty() {
            return !this.isBeforeEnd(this.firstNode());
        }

        @Override
        public boolean containsValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Node<K, V> n = this.firstNode();
            while (this.isBeforeEnd(n)) {
                V v = n.getValidValue();
                if (v != null && value.equals(v)) {
                    return true;
                }
                n = n.next;
            }
            return false;
        }

        @Override
        public void clear() {
            Node<K, V> n = this.firstNode();
            while (this.isBeforeEnd(n)) {
                if (n.getValidValue() != null) {
                    this.m.remove(n.key);
                }
                n = n.next;
            }
        }

        @Override
        public V putIfAbsent(K key, V value) {
            this.checkKey(key);
            return this.m.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            Object k = key;
            return this.inHalfOpenRange(k) && this.m.remove(k, value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            this.checkKey(key);
            return this.m.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            this.checkKey(key);
            return this.m.replace(key, value);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public K firstKey() {
            Node<K, V> n = this.firstNode();
            if (this.isBeforeEnd(n)) {
                return n.key;
            }
            throw new NoSuchElementException();
        }

        @Override
        public K lastKey() {
            Object last;
            Node<K, V> n = this.lastNode();
            if (n != null && this.inHalfOpenRange(last = n.key)) {
                return last;
            }
            throw new NoSuchElementException();
        }

        @Override
        public ConcurrentNavigableMap<K, V> subMap(K fromKey, K toKey) {
            if (fromKey == null || toKey == null) {
                throw new NullPointerException();
            }
            if (!this.inOpenRange(fromKey) || !this.inOpenRange(toKey)) {
                throw new IllegalArgumentException("key out of range");
            }
            return new ConcurrentSkipListSubMap<K, V>(this.m, fromKey, toKey);
        }

        @Override
        public ConcurrentNavigableMap<K, V> headMap(K toKey) {
            if (toKey == null) {
                throw new NullPointerException();
            }
            if (!this.inOpenRange(toKey)) {
                throw new IllegalArgumentException("key out of range");
            }
            return new ConcurrentSkipListSubMap<K, V>(this.m, this.least, toKey);
        }

        @Override
        public ConcurrentNavigableMap<K, V> tailMap(K fromKey) {
            if (fromKey == null) {
                throw new NullPointerException();
            }
            if (!this.inOpenRange(fromKey)) {
                throw new IllegalArgumentException("key out of range");
            }
            return new ConcurrentSkipListSubMap<K, V>(this.m, fromKey, this.fence);
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            return (SnapshotEntry)this.m.getNear(key, 0 | 1, this.least, this.fence, false);
        }

        @Override
        public K ceilingKey(K key) {
            return (K)this.m.getNear(key, 0 | 1, this.least, this.fence, true);
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            return (SnapshotEntry)this.m.getNear(key, 2, this.least, this.fence, false);
        }

        @Override
        public K lowerKey(K key) {
            return (K)this.m.getNear(key, 2, this.least, this.fence, true);
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            return (SnapshotEntry)this.m.getNear(key, 2 | 1, this.least, this.fence, false);
        }

        @Override
        public K floorKey(K key) {
            return (K)this.m.getNear(key, 2 | 1, this.least, this.fence, true);
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            return (SnapshotEntry)this.m.getNear(key, 0, this.least, this.fence, false);
        }

        @Override
        public K higherKey(K key) {
            return (K)this.m.getNear(key, 0, this.least, this.fence, true);
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            Node<K, V> n;
            SnapshotEntry<K, V> e;
            do {
                if (this.isBeforeEnd(n = this.firstNode())) continue;
                return null;
            } while ((e = n.createSnapshot()) == null);
            return e;
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            Node<K, V> n;
            SnapshotEntry<K, V> e;
            do {
                if ((n = this.lastNode()) != null && this.inHalfOpenRange(n.key)) continue;
                return null;
            } while ((e = n.createSnapshot()) == null);
            return e;
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            return (SnapshotEntry)this.m.removeFirstEntryOfSubrange(this.least, this.fence, false);
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            return (SnapshotEntry)this.m.removeLastEntryOfSubrange(this.least, this.fence, false);
        }

        @Override
        public Set<K> keySet() {
            KeySetView ks = this.keySetView;
            return ks != null ? ks : (this.keySetView = new KeySetView());
        }

        @Override
        public Set<K> descendingKeySet() {
            DescendingKeySetView ks = this.descendingKeySetView;
            return ks != null ? ks : (this.descendingKeySetView = new DescendingKeySetView());
        }

        @Override
        public Collection<V> values() {
            ValuesView vs = this.valuesView;
            return vs != null ? vs : (this.valuesView = new ValuesView());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            EntrySetView es = this.entrySetView;
            return es != null ? es : (this.entrySetView = new EntrySetView());
        }

        @Override
        public Set<Map.Entry<K, V>> descendingEntrySet() {
            DescendingEntrySetView es = this.descendingEntrySetView;
            return es != null ? es : (this.descendingEntrySetView = new DescendingEntrySetView());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DescendingEntrySetView
        extends EntrySetView {
            DescendingEntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return ConcurrentSkipListSubMap.this.m.descendingSubMapEntryIterator(ConcurrentSkipListSubMap.this.least, ConcurrentSkipListSubMap.this.fence);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class EntrySetView
        extends AbstractSet<Map.Entry<K, V>> {
            EntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return ConcurrentSkipListSubMap.this.m.subMapEntryIterator(ConcurrentSkipListSubMap.this.least, ConcurrentSkipListSubMap.this.fence);
            }

            @Override
            public int size() {
                return ConcurrentSkipListSubMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return ConcurrentSkipListSubMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                if (!ConcurrentSkipListSubMap.this.inHalfOpenRange(key)) {
                    return false;
                }
                Object v = ConcurrentSkipListSubMap.this.m.get(key);
                return v != null && v.equals(e.getValue());
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                if (!ConcurrentSkipListSubMap.this.inHalfOpenRange(key)) {
                    return false;
                }
                return ConcurrentSkipListSubMap.this.m.remove(key, e.getValue());
            }

            @Override
            public Object[] toArray() {
                ArrayList c = new ArrayList();
                for (Map.Entry e : this) {
                    c.add(new SnapshotEntry(e.getKey(), e.getValue()));
                }
                return c.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                ArrayList c = new ArrayList();
                for (Map.Entry e : this) {
                    c.add(new SnapshotEntry(e.getKey(), e.getValue()));
                }
                return c.toArray(a);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ValuesView
        extends AbstractCollection<V> {
            ValuesView() {
            }

            @Override
            public Iterator<V> iterator() {
                return ConcurrentSkipListSubMap.this.m.subMapValueIterator(ConcurrentSkipListSubMap.this.least, ConcurrentSkipListSubMap.this.fence);
            }

            @Override
            public int size() {
                return ConcurrentSkipListSubMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return ConcurrentSkipListSubMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object v) {
                return ConcurrentSkipListSubMap.this.containsValue(v);
            }

            @Override
            public Object[] toArray() {
                ArrayList c = new ArrayList();
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    c.add(i.next());
                }
                return c.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                ArrayList c = new ArrayList();
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    c.add(i.next());
                }
                return c.toArray(a);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DescendingKeySetView
        extends KeySetView {
            DescendingKeySetView() {
            }

            @Override
            public Iterator<K> iterator() {
                return ConcurrentSkipListSubMap.this.m.descendingSubMapKeyIterator(ConcurrentSkipListSubMap.this.least, ConcurrentSkipListSubMap.this.fence);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class KeySetView
        extends AbstractSet<K> {
            KeySetView() {
            }

            @Override
            public Iterator<K> iterator() {
                return ConcurrentSkipListSubMap.this.m.subMapKeyIterator(ConcurrentSkipListSubMap.this.least, ConcurrentSkipListSubMap.this.fence);
            }

            @Override
            public int size() {
                return ConcurrentSkipListSubMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return ConcurrentSkipListSubMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object k) {
                return ConcurrentSkipListSubMap.this.containsKey(k);
            }

            @Override
            public Object[] toArray() {
                ArrayList c = new ArrayList();
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    c.add(i.next());
                }
                return c.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                ArrayList c = new ArrayList();
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    c.add(i.next());
                }
                return c.toArray(a);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DescendingEntrySet
    extends EntrySet {
        DescendingEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new DescendingEntryIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = ConcurrentSkipListMap.this.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ConcurrentSkipListMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentSkipListMap.this.isEmpty();
        }

        @Override
        public int size() {
            return ConcurrentSkipListMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentSkipListMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList();
            for (Map.Entry e : this) {
                c.add(new SnapshotEntry(e.getKey(), e.getValue()));
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList c = new ArrayList();
            for (Map.Entry e : this) {
                c.add(new SnapshotEntry(e.getKey(), e.getValue()));
            }
            return c.toArray(a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentSkipListMap.this.isEmpty();
        }

        @Override
        public int size() {
            return ConcurrentSkipListMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentSkipListMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            ConcurrentSkipListMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DescendingKeySet
    extends KeySet {
        DescendingKeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new DescendingKeyIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentSkipListMap.this.isEmpty();
        }

        @Override
        public int size() {
            return ConcurrentSkipListMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentSkipListMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ConcurrentSkipListMap.this.removep(o);
        }

        @Override
        public void clear() {
            ConcurrentSkipListMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class DescendingSubMapEntryIterator
    extends EntryIter
    implements Iterator<Map.Entry<K, V>> {
        final K least;

        DescendingSubMapEntryIterator(K least, K fence) {
            this.initDescending(least, fence);
            this.least = least;
        }

        @Override
        public Map.Entry<K, V> next() {
            this.lastValue = this.nextValue;
            this.descend(this.least);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class DescendingEntryIterator
    extends EntryIter
    implements Iterator<Map.Entry<K, V>> {
        DescendingEntryIterator() {
            this.initDescending();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.lastValue = this.nextValue;
            this.descend();
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class SubMapEntryIterator
    extends EntryIter
    implements Iterator<Map.Entry<K, V>> {
        final K fence;

        SubMapEntryIterator(K least, K fence) {
            this.initAscending(least, fence);
            this.fence = fence;
        }

        @Override
        public Map.Entry<K, V> next() {
            this.lastValue = this.nextValue;
            this.ascend(this.fence);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntryIterator
    extends EntryIter
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
            this.initAscending();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.lastValue = this.nextValue;
            this.ascend();
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class EntryIter
    extends Iter
    implements Map.Entry<K, V> {
        Object lastValue;

        EntryIter() {
        }

        @Override
        public K getKey() {
            Node l = this.last;
            if (l == null) {
                throw new IllegalStateException();
            }
            return l.key;
        }

        @Override
        public V getValue() {
            Object v = this.lastValue;
            if (this.last == null || v == null) {
                throw new IllegalStateException();
            }
            return v;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (this.last == null) {
                return super.equals(o);
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.getKey().equals(e.getKey()) && this.getValue().equals(e.getValue());
        }

        @Override
        public int hashCode() {
            if (this.last == null) {
                return super.hashCode();
            }
            return this.getKey().hashCode() ^ this.getValue().hashCode();
        }

        public String toString() {
            if (this.last == null) {
                return super.toString();
            }
            return this.getKey() + "=" + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class DescendingSubMapKeyIterator
    extends Iter
    implements Iterator<K> {
        final K least;

        DescendingSubMapKeyIterator(K least, K fence) {
            this.initDescending(least, fence);
            this.least = least;
        }

        @Override
        public K next() {
            Node n = this.next;
            this.descend(this.least);
            return n.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class DescendingKeyIterator
    extends Iter
    implements Iterator<K> {
        DescendingKeyIterator() {
            this.initDescending();
        }

        @Override
        public K next() {
            Node n = this.next;
            this.descend();
            return n.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class SubMapKeyIterator
    extends Iter
    implements Iterator<K> {
        final K fence;

        SubMapKeyIterator(K least, K fence) {
            this.initAscending(least, fence);
            this.fence = fence;
        }

        @Override
        public K next() {
            Node n = this.next;
            this.ascend(this.fence);
            return n.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SubMapValueIterator
    extends Iter
    implements Iterator<V> {
        final K fence;

        SubMapValueIterator(K least, K fence) {
            this.initAscending(least, fence);
            this.fence = fence;
        }

        @Override
        public V next() {
            Object v = this.nextValue;
            this.ascend(this.fence);
            return v;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeyIterator
    extends Iter
    implements Iterator<K> {
        KeyIterator() {
            this.initAscending();
        }

        @Override
        public K next() {
            Node n = this.next;
            this.ascend();
            return n.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValueIterator
    extends Iter
    implements Iterator<V> {
        ValueIterator() {
            this.initAscending();
        }

        @Override
        public V next() {
            Object v = this.nextValue;
            this.ascend();
            return v;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class Iter {
        Node<K, V> last;
        Node<K, V> next;
        Object nextValue;

        Iter() {
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final void initAscending() {
            do {
                this.next = ConcurrentSkipListMap.this.findFirst();
                if (this.next == null) break;
                this.nextValue = this.next.value;
            } while (this.nextValue == null || this.nextValue == this.next);
        }

        final void initAscending(K least, K fence) {
            block2: {
                do {
                    this.next = ConcurrentSkipListMap.this.findCeiling(least);
                    if (this.next == null) break block2;
                    this.nextValue = this.next.value;
                } while (this.nextValue == null || this.nextValue == this.next);
                if (fence != null && ConcurrentSkipListMap.this.compare(fence, this.next.key) <= 0) {
                    this.next = null;
                    this.nextValue = null;
                }
            }
        }

        final void ascend() {
            this.last = this.next;
            if (this.last == null) {
                throw new NoSuchElementException();
            }
            do {
                this.next = this.next.next;
                if (this.next == null) break;
                this.nextValue = this.next.value;
            } while (this.nextValue == null || this.nextValue == this.next);
        }

        final void ascend(K fence) {
            block3: {
                this.last = this.next;
                if (this.last == null) {
                    throw new NoSuchElementException();
                }
                do {
                    this.next = this.next.next;
                    if (this.next == null) break block3;
                    this.nextValue = this.next.value;
                } while (this.nextValue == null || this.nextValue == this.next);
                if (fence != null && ConcurrentSkipListMap.this.compare(fence, this.next.key) <= 0) {
                    this.next = null;
                    this.nextValue = null;
                }
            }
        }

        final void initDescending() {
            do {
                this.next = ConcurrentSkipListMap.this.findLast();
                if (this.next == null) break;
                this.nextValue = this.next.value;
            } while (this.nextValue == null || this.nextValue == this.next);
        }

        final void initDescending(K least, K fence) {
            block2: {
                do {
                    this.next = ConcurrentSkipListMap.this.findLower(fence);
                    if (this.next == null) break block2;
                    this.nextValue = this.next.value;
                } while (this.nextValue == null || this.nextValue == this.next);
                if (least != null && ConcurrentSkipListMap.this.compare(least, this.next.key) > 0) {
                    this.next = null;
                    this.nextValue = null;
                }
            }
        }

        final void descend() {
            this.last = this.next;
            if (this.last == null) {
                throw new NoSuchElementException();
            }
            Object k = this.last.key;
            do {
                this.next = ConcurrentSkipListMap.this.findNear(k, 2);
                if (this.next == null) break;
                this.nextValue = this.next.value;
            } while (this.nextValue == null || this.nextValue == this.next);
        }

        final void descend(K least) {
            block3: {
                this.last = this.next;
                if (this.last == null) {
                    throw new NoSuchElementException();
                }
                Object k = this.last.key;
                do {
                    this.next = ConcurrentSkipListMap.this.findNear(k, 2);
                    if (this.next == null) break block3;
                    this.nextValue = this.next.value;
                } while (this.nextValue == null || this.nextValue == this.next);
                if (least != null && ConcurrentSkipListMap.this.compare(least, this.next.key) > 0) {
                    this.next = null;
                    this.nextValue = null;
                }
            }
        }

        public void remove() {
            Node l = this.last;
            if (l == null) {
                throw new IllegalStateException();
            }
            ConcurrentSkipListMap.this.remove(l.key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ComparableUsingComparator<K>
    implements Comparable<K> {
        final K actualKey;
        final Comparator<? super K> cmp;

        ComparableUsingComparator(K key, Comparator<? super K> cmp) {
            this.actualKey = key;
            this.cmp = cmp;
        }

        @Override
        public int compareTo(K k2) {
            return this.cmp.compare(this.actualKey, k2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SnapshotEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        SnapshotEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class HeadIndex<K, V>
    extends Index<K, V> {
        final int level;

        HeadIndex(Node<K, V> node, Index<K, V> down, Index<K, V> right, int level) {
            super(node, down, right);
            this.level = level;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Index<K, V> {
        final K key;
        final Node<K, V> node;
        final Index<K, V> down;
        volatile Index<K, V> right;
        static final AtomicReferenceFieldUpdater<Index, Index> rightUpdater = AccessController.doPrivileged(new PrivilegedAction<AtomicReferenceFieldUpdater<Index, Index>>(){

            @Override
            public AtomicReferenceFieldUpdater<Index, Index> run() {
                return AtomicReferenceFieldUpdater.newUpdater(Index.class, Index.class, "right");
            }
        });

        Index(Node<K, V> node, Index<K, V> down, Index<K, V> right) {
            this.node = node;
            this.key = node.key;
            this.down = down;
            this.right = right;
        }

        final boolean casRight(Index<K, V> cmp, Index<K, V> val) {
            return rightUpdater.compareAndSet(this, cmp, val);
        }

        final boolean indexesDeletedNode() {
            return this.node.value == null;
        }

        final boolean link(Index<K, V> succ, Index<K, V> newSucc) {
            Node<K, V> n = this.node;
            newSucc.right = succ;
            return n.value != null && this.casRight(succ, newSucc);
        }

        final boolean unlink(Index<K, V> succ) {
            return !this.indexesDeletedNode() && this.casRight(succ, succ.right);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Node<K, V> {
        final K key;
        volatile Object value;
        volatile Node<K, V> next;
        static final AtomicReferenceFieldUpdater<Node, Node> nextUpdater = AccessController.doPrivileged(new PrivilegedAction<AtomicReferenceFieldUpdater<Node, Node>>(){

            @Override
            public AtomicReferenceFieldUpdater<Node, Node> run() {
                return AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");
            }
        });
        static final AtomicReferenceFieldUpdater<Node, Object> valueUpdater = AccessController.doPrivileged(new PrivilegedAction<AtomicReferenceFieldUpdater<Node, Object>>(){

            @Override
            public AtomicReferenceFieldUpdater<Node, Object> run() {
                return AtomicReferenceFieldUpdater.newUpdater(Node.class, Object.class, "value");
            }
        });

        Node(K key, Object value, Node<K, V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        Node(Node<K, V> next) {
            this.key = null;
            this.value = this;
            this.next = next;
        }

        boolean casValue(Object cmp, Object val) {
            return valueUpdater.compareAndSet(this, cmp, val);
        }

        boolean casNext(Node<K, V> cmp, Node<K, V> val) {
            return nextUpdater.compareAndSet(this, cmp, val);
        }

        boolean isMarker() {
            return this.value == this;
        }

        boolean isBaseHeader() {
            return this.value == BASE_HEADER;
        }

        boolean appendMarker(Node<K, V> f) {
            return this.casNext(f, new Node<K, V>(f));
        }

        void helpDelete(Node<K, V> b, Node<K, V> f) {
            if (f == this.next && this == b.next) {
                if (f == null || f.value != f) {
                    this.appendMarker(f);
                } else {
                    b.casNext(this, f.next);
                }
            }
        }

        V getValidValue() {
            Object v = this.value;
            if (v == this || v == BASE_HEADER) {
                return null;
            }
            return (V)v;
        }

        SnapshotEntry<K, V> createSnapshot() {
            V v = this.getValidValue();
            if (v == null) {
                return null;
            }
            return new SnapshotEntry<K, V>(this.key, v);
        }
    }
}

