/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class StripedLock {
    private static final Log log = LogFactory.getLog(StripedLock.class);
    private static final int DEFAULT_CONCURRENCY = 20;
    private final int lockSegmentMask;
    private final int lockSegmentShift;
    final ReentrantReadWriteLock[] sharedLocks;

    public StripedLock() {
        this(20);
    }

    public StripedLock(int concurrency) {
        int numLocks;
        int tempLockSegShift = 0;
        for (numLocks = 1; numLocks < concurrency; numLocks <<= 1) {
            ++tempLockSegShift;
        }
        this.lockSegmentShift = 32 - tempLockSegShift;
        this.lockSegmentMask = numLocks - 1;
        this.sharedLocks = new ReentrantReadWriteLock[numLocks];
        for (int i = 0; i < numLocks; ++i) {
            this.sharedLocks[i] = new ReentrantReadWriteLock();
        }
    }

    public void acquireLock(Object key, boolean exclusive) {
        ReentrantReadWriteLock lock = this.getLock(key);
        if (exclusive) {
            lock.writeLock().lock();
            if (log.isTraceEnabled()) {
                log.tracef("WL acquired for '%s'", key);
            }
        } else {
            lock.readLock().lock();
            if (log.isTraceEnabled()) {
                log.tracef("RL acquired for '%s'", key);
            }
        }
    }

    public boolean acquireLock(Object key, boolean exclusive, long millis) {
        ReentrantReadWriteLock lock = this.getLock(key);
        try {
            if (exclusive) {
                return lock.writeLock().tryLock(millis, TimeUnit.MILLISECONDS);
            }
            return lock.readLock().tryLock(millis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.interruptedAcquiringLock(millis, e);
            return false;
        }
    }

    public void releaseLock(Object key) {
        ReentrantReadWriteLock lock = this.getLock(key);
        if (lock.isWriteLockedByCurrentThread()) {
            lock.writeLock().unlock();
            log.tracef("WL released for '%s'", key);
        } else {
            lock.readLock().unlock();
            log.tracef("RL released for '%s'", key);
        }
    }

    final ReentrantReadWriteLock getLock(Object o) {
        return this.sharedLocks[this.hashToIndex(o)];
    }

    final int hashToIndex(Object o) {
        return StripedLock.hash(o) >>> this.lockSegmentShift & this.lockSegmentMask;
    }

    static final int hash(Object x) {
        int h = x.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    public void releaseAllLocks(List<Object> keys) {
        for (Object k : keys) {
            this.releaseLock(k);
        }
    }

    public void acquireAllLocks(List<Object> keys, boolean exclusive) {
        for (Object k : keys) {
            this.acquireLock(k, exclusive);
        }
    }

    public int getTotalLockCount() {
        int count = 0;
        for (ReentrantReadWriteLock lock : this.sharedLocks) {
            count += lock.getReadLockCount();
            count += lock.isWriteLocked() ? 1 : 0;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean aquireGlobalLock(boolean exclusive, long timeout) {
        boolean success = true;
        for (int i = 0; i < this.sharedLocks.length; ++i) {
            Lock toRelease;
            block12: {
                Lock toAcquire = exclusive ? this.sharedLocks[i].writeLock() : this.sharedLocks[i].readLock();
                try {
                    success = toAcquire.tryLock(timeout, TimeUnit.MILLISECONDS);
                    if (success) break block12;
                    if (log.isTraceEnabled()) {
                        log.tracef("Could not aquire lock on %s. Exclusive? %b", toAcquire, exclusive);
                    }
                    if (success) break;
                }
                catch (InterruptedException e) {
                    try {
                        if (log.isTraceEnabled()) {
                            log.trace("Cought InterruptedException while trying to aquire global lock", e);
                        }
                        success = false;
                        Thread.currentThread().interrupt();
                        if (success) continue;
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            for (int j = 0; j < i; ++j) {
                                Lock toRelease2 = exclusive ? this.sharedLocks[j].writeLock() : this.sharedLocks[j].readLock();
                                toRelease2.unlock();
                            }
                        }
                        throw throwable;
                    }
                    for (int j = 0; j < i; ++j) {
                        toRelease = exclusive ? this.sharedLocks[j].writeLock() : this.sharedLocks[j].readLock();
                        toRelease.unlock();
                    }
                    continue;
                }
                for (int j = 0; j < i; ++j) {
                    toRelease = exclusive ? this.sharedLocks[j].writeLock() : this.sharedLocks[j].readLock();
                    toRelease.unlock();
                }
                break;
            }
            if (success) continue;
            for (int j = 0; j < i; ++j) {
                toRelease = exclusive ? this.sharedLocks[j].writeLock() : this.sharedLocks[j].readLock();
                toRelease.unlock();
            }
            continue;
        }
        return success;
    }

    public void releaseGlobalLock(boolean exclusive) {
        for (ReentrantReadWriteLock lock : this.sharedLocks) {
            Lock toRelease = exclusive ? lock.writeLock() : lock.readLock();
            toRelease.unlock();
        }
    }

    public int getTotalReadLockCount() {
        int count = 0;
        for (ReentrantReadWriteLock lock : this.sharedLocks) {
            count += lock.getReadLockCount();
        }
        return count;
    }

    public int getSharedLockCount() {
        return this.sharedLocks.length;
    }

    public int getTotalWriteLockCount() {
        int count = 0;
        for (ReentrantReadWriteLock lock : this.sharedLocks) {
            count += lock.isWriteLocked() ? 1 : 0;
        }
        return count;
    }
}

