/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Map;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.marshall.NotSerializableException;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class IsMarshallableInterceptor
extends CommandInterceptor {
    private StreamingMarshaller marshaller;
    private DistributionManager distManager;
    private boolean storeAsBinary;
    private static final Log log = LogFactory.getLog(IsMarshallableInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    protected void injectMarshaller(@ComponentName(value="org.infinispan.marshaller.cache") StreamingMarshaller marshaller, DistributionManager distManager) {
        this.marshaller = marshaller;
        this.distManager = distManager;
    }

    @Start
    protected void start() {
        this.storeAsBinary = this.configuration.isStoreAsBinary() && (this.configuration.isStoreKeysAsBinary() || this.configuration.isStoreValuesAsBinary());
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object key = command.getKey();
        if (this.isStoreAsBinary() || this.getMightGoRemote(ctx, key)) {
            this.checkMarshallable(key);
        }
        return super.visitGetKeyValueCommand(ctx, command);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (this.isStoreAsBinary() || this.isClusterInvocation(ctx)) {
            this.checkMarshallable(command.getKeys());
        }
        return super.visitLockControlCommand(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (this.isStoreAsBinary() || this.isClusterInvocation(ctx) || this.isStoreInvocation(ctx)) {
            this.checkMarshallable(command.getKey(), command.getValue());
        }
        return super.visitPutKeyValueCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (this.isStoreAsBinary() || this.isClusterInvocation(ctx) || this.isStoreInvocation(ctx)) {
            this.checkMarshallable(command.getMap());
        }
        return super.visitPutMapCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        if (this.isStoreAsBinary() || this.isClusterInvocation(ctx) || this.isStoreInvocation(ctx)) {
            this.checkMarshallable(command.getKey());
        }
        return super.visitRemoveCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        if (this.isStoreAsBinary() || this.isClusterInvocation(ctx) || this.isStoreInvocation(ctx)) {
            this.checkMarshallable(command.getKey(), command.getNewValue());
        }
        return super.visitReplaceCommand(ctx, command);
    }

    private boolean isClusterInvocation(InvocationContext ctx) {
        return ctx.isOriginLocal() && this.configuration.getCacheMode().isClustered() && !ctx.hasFlag(Flag.CACHE_MODE_LOCAL);
    }

    private boolean isStoreInvocation(InvocationContext ctx) {
        return !this.configuration.getCacheMode().isClustered() && this.configuration.getCacheLoaderManagerConfig().getFirstCacheLoaderConfig() != null && !ctx.hasFlag(Flag.SKIP_CACHE_STORE);
    }

    private boolean isStoreAsBinary() {
        return this.storeAsBinary;
    }

    private boolean getMightGoRemote(InvocationContext ctx, Object key) {
        return ctx.isOriginLocal() && this.configuration.getCacheMode().isDistributed() && !ctx.hasFlag(Flag.SKIP_REMOTE_LOOKUP) && !this.distManager.getLocality(key).isLocal();
    }

    private void checkMarshallable(Object ... objs) throws NotSerializableException {
        for (Object o : objs) {
            boolean marshallable = false;
            try {
                marshallable = this.marshaller.isMarshallable(o);
            }
            catch (Exception e) {
                this.throwNotSerializable(o, e);
            }
            if (marshallable) continue;
            this.throwNotSerializable(o, null);
        }
    }

    private void throwNotSerializable(Object o, Throwable t) {
        String msg = String.format("Object of type %s expected to be marshallable", o.getClass());
        if (t == null) {
            throw new NotSerializableException(msg);
        }
        throw new NotSerializableException(msg, t);
    }

    private void checkMarshallable(Map<Object, Object> objs) throws NotSerializableException {
        for (Map.Entry<Object, Object> entry : objs.entrySet()) {
            this.checkMarshallable(entry.getKey(), entry.getValue());
        }
    }
}

