/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.embedded.ejb3;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.embedded.EmbeddedLogger;
import org.jboss.as.embedded.EmbeddedMessages;
import org.jboss.as.embedded.ejb3.ExclusionFilter;
import org.jboss.vfs.VirtualFile;

public class BundleSymbolicNameExclusionFilter
implements ExclusionFilter {
    private static final String HEADER_BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String NAME_MANIFEST = "META-INF/MANIFEST.MF";
    private final Set<String> exclusionValues;

    public BundleSymbolicNameExclusionFilter(String ... exclusionValues) throws IllegalArgumentException {
        if (exclusionValues == null || exclusionValues.length == 0) {
            throw EmbeddedMessages.MESSAGES.exclusionValuesRequired();
        }
        HashSet<String> excludeSet = new HashSet<String>();
        for (String exclusionValue : exclusionValues) {
            excludeSet.add(exclusionValue);
        }
        this.exclusionValues = Collections.unmodifiableSet(excludeSet);
    }

    @Override
    public boolean exclude(VirtualFile file) {
        if (file == null) {
            throw EmbeddedMessages.MESSAGES.nullVar("file");
        }
        if (!file.exists()) {
            return false;
        }
        VirtualFile manifest = file.getChild(NAME_MANIFEST);
        if (!manifest.exists()) {
            return false;
        }
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(manifest.openStream()));
            while ((line = reader.readLine()) != null) {
                String header = HEADER_BUNDLE_SYMBOLIC_NAME;
                if (!line.contains(HEADER_BUNDLE_SYMBOLIC_NAME)) continue;
                for (String exclusionValue : this.exclusionValues) {
                    if (!line.contains(exclusionValue)) continue;
                    if (EmbeddedLogger.ROOT_LOGGER.isTraceEnabled()) {
                        EmbeddedLogger.ROOT_LOGGER.tracef("Configured exclusion value \"%s\" encountered in manifest header \"%s\"; skipping %s", exclusionValue, HEADER_BUNDLE_SYMBOLIC_NAME, file);
                    }
                    return true;
                }
            }
        }
        catch (IOException ioe) {
            throw EmbeddedMessages.MESSAGES.cannotReadContent(ioe, file);
        }
        return false;
    }
}

