/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class EJBClientDescriptorMetaData {
    private boolean excludeLocalReceiver;
    private Boolean localReceiverPassByValue;
    private Set<String> remotingReceiverConnectionRefs = new HashSet<String>();
    private Set<ClusterConfig> clusterConfigs = new HashSet<ClusterConfig>();

    public void addRemotingReceiverConnectionRef(String outboundConnectionRef) {
        if (outboundConnectionRef == null || outboundConnectionRef.trim().isEmpty()) {
            throw new IllegalArgumentException("Cannot add a remoting receiver which references a null/empty outbound connection");
        }
        this.remotingReceiverConnectionRefs.add(outboundConnectionRef);
    }

    public Collection<String> getRemotingReceiverConnectionRefs() {
        return this.remotingReceiverConnectionRefs;
    }

    public void setLocalReceiverPassByValue(Boolean passByValue) {
        this.localReceiverPassByValue = passByValue;
    }

    public Boolean isLocalReceiverPassByValue() {
        return this.localReceiverPassByValue;
    }

    public void setExcludeLocalReceiver(boolean excludeLocalReceiver) {
        this.excludeLocalReceiver = excludeLocalReceiver;
    }

    public boolean isLocalReceiverExcluded() {
        return this.excludeLocalReceiver;
    }

    public Collection<ClusterConfig> getClusterConfigs() {
        return Collections.unmodifiableSet(this.clusterConfigs);
    }

    public ClusterConfig newClusterConfig(String clusterName) {
        ClusterConfig clusterConfig = new ClusterConfig(clusterName);
        this.clusterConfigs.add(clusterConfig);
        return clusterConfig;
    }

    private class CommonConnectionConfig {
        private Properties connectionOptions;
        private Properties channelCreationOptions;
        private long connectTimeout;
        private String userName;
        private String securityRealm;

        private CommonConnectionConfig() {
        }

        public void setConnectionOptions(Properties connectionOptions) {
            this.connectionOptions = connectionOptions;
        }

        public void setChannelCreationOptions(Properties channelCreationOptions) {
            this.channelCreationOptions = channelCreationOptions;
        }

        public long getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(long timeout) {
            this.connectTimeout = timeout;
        }

        public Properties getConnectionOptions() {
            return this.connectionOptions;
        }

        public Properties getChannelCreationOptions() {
            return this.channelCreationOptions;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setSecurityRealm(String realm) {
            this.securityRealm = realm;
        }

        public String getSecurityRealm() {
            return this.securityRealm;
        }
    }

    public class ClusterNodeConfig
    extends CommonConnectionConfig {
        private final String nodeName;

        ClusterNodeConfig(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterNodeConfig that = (ClusterNodeConfig)o;
            return this.nodeName.equals(that.nodeName);
        }

        public int hashCode() {
            return this.nodeName.hashCode();
        }
    }

    public class ClusterConfig
    extends CommonConnectionConfig {
        private final String clusterName;
        private final Set<ClusterNodeConfig> nodes = new HashSet<ClusterNodeConfig>();
        private long maxAllowedConnectedNodes;
        private String nodeSelector;

        ClusterConfig(String clusterName) {
            this.clusterName = clusterName;
        }

        public ClusterNodeConfig newClusterNode(String nodeName) {
            ClusterNodeConfig node = new ClusterNodeConfig(nodeName);
            this.nodes.add(node);
            return node;
        }

        public Collection<ClusterNodeConfig> getClusterNodeConfigs() {
            return Collections.unmodifiableSet(this.nodes);
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public long getMaxAllowedConnectedNodes() {
            return this.maxAllowedConnectedNodes;
        }

        public void setMaxAllowedConnectedNodes(long maxAllowedConnectedNodes) {
            this.maxAllowedConnectedNodes = maxAllowedConnectedNodes;
        }

        public void setNodeSelector(String nodeSelector) {
            this.nodeSelector = nodeSelector;
        }

        public String getNodeSelector() {
            return this.nodeSelector;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterConfig that = (ClusterConfig)o;
            return this.clusterName.equals(that.clusterName);
        }

        public int hashCode() {
            return this.clusterName.hashCode();
        }
    }
}

