/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.Deflater;

public class DeflaterReader
extends InputStream {
    private final Deflater deflater = new Deflater();
    private boolean isFinished = false;
    private boolean compressDone = false;
    private InputStream input;
    private final AtomicLong bytesRead;

    public DeflaterReader(InputStream inData, AtomicLong bytesRead) {
        this.input = inData;
        this.bytesRead = bytesRead;
    }

    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int n = this.read(buffer, 0, 1);
        if (n == 1) {
            return buffer[0] & 0xFF;
        }
        if (n == -1 || n == 0) {
            return -1;
        }
        throw new IOException("Error reading data, invalid n: " + n);
    }

    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (this.compressDone) {
            return -1;
        }
        byte[] readBuffer = new byte[2 * len];
        int n = 0;
        int read = 0;
        while (len > 0) {
            n = this.deflater.deflate(buffer, offset, len);
            if (n == 0) {
                if (this.isFinished) {
                    this.deflater.end();
                    this.compressDone = true;
                    break;
                }
                if (this.deflater.needsInput()) {
                    int m = this.input.read(readBuffer);
                    if (m == -1) {
                        this.deflater.finish();
                        this.isFinished = true;
                        continue;
                    }
                    if (this.bytesRead != null) {
                        this.bytesRead.addAndGet(m);
                    }
                    this.deflater.setInput(readBuffer, 0, m);
                    continue;
                }
                this.deflater.finish();
                this.isFinished = true;
                continue;
            }
            read += n;
            offset += n;
            len -= n;
        }
        return read;
    }
}

