/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.client.HornetQBytesMessage;
import org.hornetq.jms.client.HornetQConnection;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.client.HornetQMapMessage;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.jms.client.HornetQObjectMessage;
import org.hornetq.jms.client.HornetQStreamMessage;
import org.hornetq.jms.client.HornetQTextMessage;
import org.hornetq.jms.client.JMSExceptionHelper;
import org.hornetq.utils.UUID;
import org.hornetq.utils.UUIDGenerator;

public class HornetQMessageProducer
implements MessageProducer,
QueueSender,
TopicPublisher {
    private static final Logger log = Logger.getLogger(HornetQMessageProducer.class);
    private final HornetQConnection jbossConn;
    private final SimpleString connID;
    private final ClientProducer producer;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    private int defaultPriority = 4;
    private long defaultTimeToLive = 0L;
    private int defaultDeliveryMode = 2;
    private final HornetQDestination defaultDestination;
    private final ClientSession clientSession;

    protected HornetQMessageProducer(HornetQConnection jbossConn, ClientProducer producer, HornetQDestination defaultDestination, ClientSession clientSession) throws JMSException {
        this.jbossConn = jbossConn;
        this.connID = jbossConn.getUID();
        this.producer = producer;
        this.defaultDestination = defaultDestination;
        this.clientSession = clientSession;
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageID = value;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageTimestamp = value;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkClosed();
        this.defaultDeliveryMode = deliveryMode;
    }

    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.defaultDeliveryMode;
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.checkClosed();
        this.defaultPriority = defaultPriority;
    }

    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.defaultPriority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkClosed();
        this.defaultTimeToLive = timeToLive;
    }

    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.defaultTimeToLive;
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.defaultDestination;
    }

    public void close() throws JMSException {
        try {
            this.producer.close();
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public void send(javax.jms.Message message) throws JMSException {
        this.checkClosed();
        message.setJMSDeliveryMode(this.defaultDeliveryMode);
        message.setJMSPriority(this.defaultPriority);
        this.doSend(message, this.defaultTimeToLive, null);
    }

    public void send(javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        this.doSend(message, timeToLive, null);
    }

    public void send(Destination destination, javax.jms.Message message) throws JMSException {
        this.checkClosed();
        if (destination != null && !(destination instanceof HornetQDestination)) {
            throw new InvalidDestinationException("Not a HornetQ Destination:" + destination);
        }
        message.setJMSDeliveryMode(this.defaultDeliveryMode);
        message.setJMSPriority(this.defaultPriority);
        this.doSend(message, this.defaultTimeToLive, (HornetQDestination)destination);
    }

    public void send(Destination destination, javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        if (destination != null && !(destination instanceof HornetQDestination)) {
            throw new InvalidDestinationException("Not a HornetQ Destination:" + destination);
        }
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        this.doSend(message, timeToLive, (HornetQDestination)destination);
    }

    public Topic getTopic() throws JMSException {
        return (Topic)this.getDestination();
    }

    public void publish(javax.jms.Message message) throws JMSException {
        this.send(message);
    }

    public void publish(Topic topic, javax.jms.Message message) throws JMSException {
        this.send(topic, message);
    }

    public void publish(javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(topic, message, deliveryMode, priority, timeToLive);
    }

    public void send(Queue queue, javax.jms.Message message) throws JMSException {
        this.send((Destination)queue, message);
    }

    public void send(Queue queue, javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send((Destination)queue, message, deliveryMode, priority, timeToLive);
    }

    public Queue getQueue() throws JMSException {
        return (Queue)this.getDestination();
    }

    public String toString() {
        return "HornetQRAMessageProducer->" + this.producer;
    }

    private void doSend(javax.jms.Message message, long timeToLive, HornetQDestination destination) throws JMSException {
        HornetQMessage msg;
        if (timeToLive == 0L) {
            message.setJMSExpiration(0L);
        } else {
            message.setJMSExpiration(System.currentTimeMillis() + timeToLive);
        }
        if (!this.disableMessageTimestamp) {
            message.setJMSTimestamp(System.currentTimeMillis());
        } else {
            message.setJMSTimestamp(0L);
        }
        SimpleString address = null;
        if (destination == null) {
            if (this.defaultDestination == null) {
                throw new UnsupportedOperationException("Destination must be specified on send with an anonymous producer");
            }
            destination = this.defaultDestination;
        } else {
            if (this.defaultDestination != null && !destination.equals(this.defaultDestination)) {
                throw new UnsupportedOperationException("Where a default destination is specified for the sender and a destination is specified in the arguments to the send, these destinations must be equal");
            }
            address = destination.getSimpleAddress();
        }
        boolean foreign = false;
        if (!(message instanceof HornetQMessage)) {
            msg = message instanceof BytesMessage ? new HornetQBytesMessage((BytesMessage)message, this.clientSession) : (message instanceof MapMessage ? new HornetQMapMessage((MapMessage)message, this.clientSession) : (message instanceof ObjectMessage ? new HornetQObjectMessage((ObjectMessage)message, this.clientSession) : (message instanceof StreamMessage ? new HornetQStreamMessage((StreamMessage)message, this.clientSession) : (message instanceof TextMessage ? new HornetQTextMessage((TextMessage)message, this.clientSession) : new HornetQMessage(message, this.clientSession)))));
            message.setJMSDestination(destination);
            foreign = true;
        } else {
            msg = (HornetQMessage)message;
        }
        if (!this.disableMessageID) {
            UUID uid = UUIDGenerator.getInstance().generateUUID();
            msg.getCoreMessage().setUserID(uid);
            msg.resetMessageID(null);
        }
        if (foreign) {
            message.setJMSMessageID(msg.getJMSMessageID());
        }
        msg.setJMSDestination(destination);
        try {
            msg.doBeforeSend();
        }
        catch (Exception e) {
            JMSException je = new JMSException(e.getMessage());
            je.initCause(e);
            throw je;
        }
        ClientMessage coreMessage = msg.getCoreMessage();
        if (this.jbossConn.hasNoLocal()) {
            coreMessage.putStringProperty(HornetQConnection.CONNECTION_ID_PROPERTY_NAME, this.connID);
        } else {
            coreMessage.removeProperty(HornetQConnection.CONNECTION_ID_PROPERTY_NAME);
        }
        try {
            this.producer.send(address, (Message)coreMessage);
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    private void checkClosed() throws JMSException {
        if (this.producer.isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
    }
}

