/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.jms.management;

import java.util.Map;
import org.hornetq.api.core.management.Operation;
import org.hornetq.api.core.management.Parameter;
import org.hornetq.api.jms.management.DestinationControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface TopicControl
extends DestinationControl {
    public int getSubscriptionCount();

    public int getDurableSubscriptionCount();

    public int getNonDurableSubscriptionCount();

    public int getDurableMessageCount();

    public int getNonDurableMessageCount();

    @Operation(desc="Returns the list of JNDI bindings associated")
    public String[] getJNDIBindings();

    @Operation(desc="Add the queue to another JNDI binding")
    public void addJNDI(@Parameter(name="jndiBinding", desc="the name of the binding for JNDI") String var1) throws Exception;

    @Operation(desc="Add the queue to another JNDI binding")
    public void removeJNDI(@Parameter(name="jndiBinding", desc="the name of the binding for JNDI") String var1) throws Exception;

    @Operation(desc="List all subscriptions")
    public Object[] listAllSubscriptions() throws Exception;

    @Operation(desc="List all subscriptions")
    public String listAllSubscriptionsAsJSON() throws Exception;

    @Operation(desc="List only the durable subscriptions")
    public Object[] listDurableSubscriptions() throws Exception;

    @Operation(desc="List only the durable subscriptions")
    public String listDurableSubscriptionsAsJSON() throws Exception;

    @Operation(desc="List only the non durable subscriptions")
    public Object[] listNonDurableSubscriptions() throws Exception;

    @Operation(desc="List only the non durable subscriptions")
    public String listNonDurableSubscriptionsAsJSON() throws Exception;

    @Operation(desc="List all the message for the given subscription")
    public Map<String, Object>[] listMessagesForSubscription(@Parameter(name="queueName", desc="the name of the queue representing a subscription") String var1) throws Exception;

    @Operation(desc="List all the message for the given subscription")
    public String listMessagesForSubscriptionAsJSON(@Parameter(name="queueName", desc="the name of the queue representing a subscription") String var1) throws Exception;

    @Operation(desc="Count the number of messages matching the filter for the given subscription")
    public int countMessagesForSubscription(@Parameter(name="clientID", desc="the client ID") String var1, @Parameter(name="subscriptionName", desc="the name of the durable subscription") String var2, @Parameter(name="filter", desc="a JMS filter (can be empty)") String var3) throws Exception;

    @Operation(desc="Drop a durable subscription", impact=1)
    public void dropDurableSubscription(@Parameter(name="clientID", desc="the client ID") String var1, @Parameter(name="subscriptionName", desc="the name of the durable subscription") String var2) throws Exception;

    @Operation(desc="Drop all subscriptions from this topic", impact=1)
    public void dropAllSubscriptions() throws Exception;
}

