/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.net.MalformedURLException;
import java.util.HashSet;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.WeldLogger;
import org.jboss.as.weld.WeldMessages;
import org.jboss.as.weld.deployment.BeanArchiveMetadata;
import org.jboss.as.weld.deployment.BeansXmlParser;
import org.jboss.as.weld.deployment.WeldDeploymentMetadata;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.bootstrap.spi.BeansXml;

public class BeansXmlProcessor
implements DeploymentUnitProcessor {
    private static final String WEB_INF_BEANS_XML = "WEB-INF/beans.xml";
    private static final String META_INF_BEANS_XML = "META-INF/beans.xml";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        VirtualFile rootBeansXml;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        BeansXmlParser parser = new BeansXmlParser();
        HashSet<BeanArchiveMetadata> beanArchiveMetadata = new HashSet<BeanArchiveMetadata>();
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        AttachmentList structure = (AttachmentList)deploymentUnit.getAttachment(Attachments.RESOURCE_ROOTS);
        if (deploymentRoot == null) {
            return;
        }
        ResourceRoot classesRoot = null;
        if (structure != null) {
            for (ResourceRoot resourceRoot : structure) {
                if (!ModuleRootMarker.isModuleRoot((ResourceRoot)resourceRoot) || SubDeploymentMarker.isSubDeployment((ResourceRoot)resourceRoot)) continue;
                if (resourceRoot.getRootName().equals("classes")) {
                    classesRoot = resourceRoot;
                    continue;
                }
                VirtualFile beansXml = resourceRoot.getRoot().getChild(META_INF_BEANS_XML);
                if (!beansXml.exists() || !beansXml.isFile()) continue;
                WeldLogger.DEPLOYMENT_LOGGER.debugf("Found beans.xml: %s", beansXml.toString());
                beanArchiveMetadata.add(new BeanArchiveMetadata(beansXml, resourceRoot, this.parseBeansXml(beansXml, parser), false));
            }
        }
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            VirtualFile beansXml;
            rootBeansXml = deploymentRoot.getRoot().getChild(WEB_INF_BEANS_XML);
            if (rootBeansXml.exists() && rootBeansXml.isFile()) {
                WeldLogger.DEPLOYMENT_LOGGER.debugf("Found beans.xml: %s", rootBeansXml);
                beanArchiveMetadata.add(new BeanArchiveMetadata(rootBeansXml, classesRoot, this.parseBeansXml(rootBeansXml, parser), true));
            } else if (classesRoot != null && (beansXml = classesRoot.getRoot().getChild(META_INF_BEANS_XML)).exists() && beansXml.isFile()) {
                WeldLogger.DEPLOYMENT_LOGGER.beansXmlInNonStandardLocation(beansXml.toString());
                beanArchiveMetadata.add(new BeanArchiveMetadata(beansXml, classesRoot, this.parseBeansXml(beansXml, parser), true));
            }
        } else if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit) && (rootBeansXml = deploymentRoot.getRoot().getChild(META_INF_BEANS_XML)).exists() && rootBeansXml.isFile()) {
            WeldLogger.DEPLOYMENT_LOGGER.debugf("Found beans.xml: %s", rootBeansXml.toString());
            beanArchiveMetadata.add(new BeanArchiveMetadata(rootBeansXml, deploymentRoot, this.parseBeansXml(rootBeansXml, parser), true));
        }
        if (!beanArchiveMetadata.isEmpty()) {
            WeldDeploymentMetadata deploymentMetadata = new WeldDeploymentMetadata(beanArchiveMetadata);
            deploymentUnit.putAttachment(WeldDeploymentMetadata.ATTACHMENT_KEY, (Object)deploymentMetadata);
            WeldDeploymentMarker.mark(deploymentUnit);
            if (deploymentUnit.getParent() != null) {
                WeldDeploymentMarker.mark(deploymentUnit.getParent());
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private BeansXml parseBeansXml(VirtualFile beansXmlFile, BeansXmlParser parser) throws DeploymentUnitProcessingException {
        try {
            return parser.parse(beansXmlFile.asFileURL());
        }
        catch (MalformedURLException e) {
            throw WeldMessages.MESSAGES.couldNotGetBeansXmlAsURL(beansXmlFile.toString(), e);
        }
    }
}

