/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.session;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.jboss.as.clustering.web.BatchingManager;
import org.jboss.as.clustering.web.OutgoingDistributableSessionData;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.session.ClusteredSession;
import org.jboss.as.web.session.SessionReplicationContext;
import org.jboss.as.web.session.SnapshotManager;
import org.jboss.servlet.http.HttpEvent;

public class ClusteredSessionValve
extends ValveBase
implements Lifecycle {
    private static final String info = "ClusteredSessionValve/1.0";
    private final LifecycleSupport support = new LifecycleSupport((Lifecycle)this);
    private final Manager manager;
    private final BatchingManager tm;

    public ClusteredSessionValve(Manager manager, BatchingManager tm) {
        assert (manager != null) : WebMessages.MESSAGES.nullManager();
        this.manager = manager;
        this.tm = tm;
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.handleRequest(request, response, null, false);
    }

    public void event(Request request, Response response, HttpEvent event) throws IOException, ServletException {
        this.handleRequest(request, response, event, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(Request request, Response response, HttpEvent event, boolean isEvent) throws IOException, ServletException {
        SessionReplicationContext.enterWebapp(request, response, true);
        boolean startedBatch = this.startBatchTransaction();
        try {
            String requestedId = request.getRequestedSessionId();
            if (requestedId != null) {
                this.manager.findSession(requestedId);
            }
            if (isEvent) {
                this.getNext().event(request, response, event);
            } else {
                this.getNext().invoke(request, response);
            }
        }
        finally {
            try {
                SessionReplicationContext ctx = SessionReplicationContext.exitWebapp();
                if (ctx.getSoleSnapshotManager() != null) {
                    ctx.getSoleSnapshotManager().snapshot(ctx.getSoleSession());
                } else {
                    this.handleCrossContextSessions(ctx);
                }
            }
            finally {
                if (startedBatch) {
                    this.tm.endBatch();
                }
            }
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.support.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.support.removeLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.support.findLifecycleListeners();
    }

    public void start() throws LifecycleException {
        this.support.fireLifecycleEvent("start", (Object)this);
    }

    public void stop() throws LifecycleException {
        this.support.fireLifecycleEvent("stop", (Object)this);
    }

    private boolean startBatchTransaction() throws ServletException {
        boolean started = false;
        try {
            if (this.tm != null && !this.tm.isBatchInProgress()) {
                this.tm.startBatch();
                started = true;
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new ServletException(WebMessages.MESSAGES.failToStartBatchTransaction(e));
        }
        return started;
    }

    private void handleCrossContextSessions(SessionReplicationContext ctx) {
        Map<ClusteredSession<? extends OutgoingDistributableSessionData>, SnapshotManager> sessions = ctx.getCrossContextSessions();
        if (sessions != null && sessions.size() > 0) {
            for (Map.Entry<ClusteredSession<? extends OutgoingDistributableSessionData>, SnapshotManager> entry : sessions.entrySet()) {
                entry.getValue().snapshot(entry.getKey());
            }
        }
    }
}

