/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment.jsf;

import com.sun.faces.spi.DiscoverableInjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import java.lang.reflect.InvocationTargetException;
import javax.naming.NamingException;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.deployment.WebInjectionContainer;

public class JsfInjectionProvider
extends DiscoverableInjectionProvider {
    private static final ThreadLocal<WebInjectionContainer> injectionContainer = new ThreadLocal();
    private final WebInjectionContainer container = injectionContainer.get();

    public JsfInjectionProvider() {
        if (this.container == null) {
            throw WebMessages.MESSAGES.noThreadLocalInjectionContainer();
        }
    }

    public void inject(Object managedBean) throws InjectionProviderException {
    }

    public void invokePreDestroy(Object managedBean) throws InjectionProviderException {
        try {
            this.container.destroyInstance(managedBean);
        }
        catch (IllegalAccessException e) {
            throw WebMessages.MESSAGES.instanceDestructionFailed(e);
        }
        catch (InvocationTargetException e) {
            throw WebMessages.MESSAGES.instanceDestructionFailed(e);
        }
    }

    public void invokePostConstruct(Object managedBean) throws InjectionProviderException {
        try {
            this.container.newInstance(managedBean);
        }
        catch (IllegalAccessException e) {
            throw WebMessages.MESSAGES.instanceCreationFailed(e);
        }
        catch (InvocationTargetException e) {
            throw WebMessages.MESSAGES.instanceCreationFailed(e);
        }
        catch (NamingException e) {
            throw WebMessages.MESSAGES.instanceCreationFailed(e);
        }
    }

    public static ThreadLocal<WebInjectionContainer> getInjectionContainer() {
        return injectionContainer;
    }
}

