/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.service;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.JAXRException;
import org.jboss.as.jaxr.JAXRConfiguration;
import org.jboss.as.jaxr.JAXRLogger;
import org.jboss.as.jaxr.JAXRMessages;
import org.jboss.as.jaxr.service.SecurityActions;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public final class JAXRConnectionFactoryService
extends AbstractService<Void> {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"jaxr", "connectionfactory"});
    private final Logger log = Logger.getLogger((String)"org.jboss.as.jaxr");
    private final InjectedValue<NamingStore> injectedJavaContext = new InjectedValue();
    private final InjectedValue<JAXRConfiguration> injectedConfig = new InjectedValue();

    public static ServiceController<?> addService(ServiceTarget target, ServiceListener<Object> ... listeners) {
        JAXRConnectionFactoryService service = new JAXRConnectionFactoryService();
        ServiceBuilder builder = target.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, NamingStore.class, service.injectedJavaContext);
        builder.addDependency(JAXRConfiguration.SERVICE_NAME, JAXRConfiguration.class, service.injectedConfig);
        builder.addListener(listeners);
        return builder.install();
    }

    private JAXRConnectionFactoryService() {
    }

    public void start(StartContext context) throws StartException {
        JAXRConfiguration config = (JAXRConfiguration)this.injectedConfig.getValue();
        if (config.getConnectionFactoryBinding() != null) {
            try {
                String jndiName = config.getConnectionFactoryBinding();
                ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
                BinderService binderService = new BinderService(bindInfo.getBindName());
                ConnectionFactory jaxrFactory = this.loadConnectionFactoryImplementation(config);
                this.setJAXRFactoryProperies(jaxrFactory, config.getProperties());
                ImmediateValue value = new ImmediateValue((Object)jaxrFactory);
                binderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value)value));
                binderService.getNamingStoreInjector().inject((Object)((ServiceBasedNamingStore)this.injectedJavaContext.getValue()));
                ServiceBuilder builder = context.getChildTarget().addService(bindInfo.getBinderServiceName(), (Service)binderService);
                JAXRLogger.JAXR_LOGGER.bindingJAXRConnectionFactory(config.getConnectionFactoryBinding());
                builder.install();
            }
            catch (Exception ex) {
                JAXRLogger.JAXR_LOGGER.bindingJAXRConnectionFactoryFailed();
            }
        }
    }

    public void stop(StopContext context) {
        JAXRConfiguration config = (JAXRConfiguration)this.injectedConfig.getValue();
        if (config.getConnectionFactoryBinding() != null) {
            try {
                String jndiName = config.getConnectionFactoryBinding();
                ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
                ServiceContainer serviceContainer = context.getController().getServiceContainer();
                ServiceController service = serviceContainer.getService(bindInfo.getBinderServiceName());
                JAXRLogger.JAXR_LOGGER.unBindingJAXRConnectionFactory(config.getConnectionFactoryBinding());
                if (service != null) {
                    service.setMode(ServiceController.Mode.REMOVE);
                }
            }
            catch (Exception ex) {
                JAXRLogger.JAXR_LOGGER.unBindingJAXRConnectionFactoryFailed();
            }
        }
    }

    protected ConnectionFactory loadConnectionFactoryImplementation(JAXRConfiguration config) throws JAXRException {
        ConnectionFactory jaxrFactory = null;
        String factoryName = SecurityActions.getSystemProperty("javax.xml.registry.ConnectionFactory", null);
        if (factoryName != null) {
            JAXRLogger.JAXR_LOGGER.factoryNameFromSystemProperty("javax.xml.registry.ConnectionFactory", factoryName);
        } else {
            factoryName = config.getConnectionFactoryImplementation();
        }
        if (factoryName != null) {
            JAXRLogger.JAXR_LOGGER.factoryNameFromJBossConfig("javax.xml.registry.ConnectionFactory", factoryName);
        } else {
            Iterator<ConnectionFactory> i$;
            ServiceLoader<ConnectionFactory> factoryLoader = ServiceLoader.load(ConnectionFactory.class);
            if (factoryLoader != null && (i$ = factoryLoader.iterator()).hasNext()) {
                ConnectionFactory factory = i$.next();
                JAXRLogger.JAXR_LOGGER.factoryNameFromServiceLoader(factory.getClass().getName());
                return factory;
            }
        }
        if (factoryName == null) {
            factoryName = "org.apache.ws.scout.registry.ConnectionFactoryImpl";
        }
        JAXRLogger.JAXR_LOGGER.factoryNameFromDefault("org.apache.ws.scout.registry.ConnectionFactoryImpl");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> factoryClass;
            try {
                factoryClass = loader.loadClass(factoryName);
            }
            catch (ClassNotFoundException e) {
                factoryClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(factoryName);
            }
            jaxrFactory = (ConnectionFactory)factoryClass.newInstance();
        }
        catch (Throwable e) {
            throw JAXRMessages.MESSAGES.couldNotInstantiateJAXRFactory(factoryName);
        }
        return jaxrFactory;
    }

    private void setJAXRFactoryProperies(ConnectionFactory jaxrFactory, Properties properties) throws JAXRException {
        String defaultQueryManager = "http://localhost:8080/juddi/inquiry";
        String defaultLifeCycleManager = "http://localhost:8080/juddi/publish";
        if (jaxrFactory.getClass().getName().equals("org.apache.ws.scout.registry.ConnectionFactoryImpl")) {
            String version = properties.getProperty("scout.proxy.uddiVersion", "2.0");
            if (version.equals("2.0")) {
                properties.setProperty("scout.proxy.uddiVersion", "2.0");
                properties.setProperty("scout.proxy.uddiNamespace", "urn:uddi-org:api_v2");
                if (!properties.containsKey("scout.proxy.transportClass")) {
                    properties.setProperty("scout.proxy.transportClass", "org.apache.ws.scout.transport.SaajTransport");
                }
            } else {
                properties.setProperty("scout.proxy.uddiVersion", "3.0");
                properties.setProperty("scout.proxy.uddiNamespace", "urn:uddi-org:api_v3");
                defaultQueryManager = "http://localhost:8880/juddiv3/inquiry";
                defaultLifeCycleManager = "http://localhost:8880/juddiv3/publish";
                if (!properties.containsKey("javax.xml.registry.securityManagerURL")) {
                    properties.setProperty("javax.xml.registry.securityManagerURL", "http://localhost:8880/juddiv3/security");
                }
                if (!properties.containsKey("scout.proxy.transportClass")) {
                    properties.setProperty("scout.proxy.transportClass", "org.apache.juddi.v3.client.transport.JAXWSTransport");
                }
                if (!properties.containsKey("scout.juddi.client.config.file")) {
                    properties.setProperty("scout.juddi.client.config.file", "jaxr-uddi.xml");
                }
            }
        }
        if (!properties.containsKey("javax.xml.registry.queryManagerURL")) {
            properties.setProperty("javax.xml.registry.queryManagerURL", defaultQueryManager);
        }
        if (!properties.containsKey("javax.xml.registry.lifeCycleManagerURL")) {
            properties.setProperty("javax.xml.registry.lifeCycleManagerURL", defaultLifeCycleManager);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("JAXR is using the " + jaxrFactory.getClass().getName() + " implementation"));
            this.log.debug((Object)"By default the following JAXR Properties are set:");
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String key = (String)propertyNames.nextElement();
                this.log.debug((Object)(key + "=" + properties.getProperty(key)));
            }
        }
        jaxrFactory.setProperties(properties);
    }
}

