/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.extension;

import java.util.EnumSet;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.DefaultResourceAddDescriptionProvider;
import org.jboss.as.controller.descriptions.DefaultResourceRemoveDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.jaxr.JAXRConfiguration;
import org.jboss.as.jaxr.extension.JAXRSubsystemAdd;
import org.jboss.as.jaxr.extension.JAXRWriteAttributeHandler;

class JAXRSubsystemRootResource
extends SimpleResourceDefinition {
    private final JAXRConfiguration config;

    JAXRSubsystemRootResource(JAXRConfiguration config) {
        super(PathElement.pathElement((String)"subsystem", (String)"jaxr"), JAXRSubsystemRootResource.getResourceDescriptionResolver("jaxr"));
        this.config = config;
    }

    private static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, "org.jboss.as.jaxr.LocalDescriptions", JAXRSubsystemRootResource.class.getClassLoader(), true, false);
    }

    public void registerOperations(ManagementResourceRegistration rootResourceRegistration) {
        ResourceDescriptionResolver rootResolver = this.getResourceDescriptionResolver();
        DefaultResourceAddDescriptionProvider subsystemAddDescription = new DefaultResourceAddDescriptionProvider((ImmutableManagementResourceRegistration)rootResourceRegistration, rootResolver);
        rootResourceRegistration.registerOperationHandler("add", (OperationStepHandler)new JAXRSubsystemAdd(this.config), (DescriptionProvider)subsystemAddDescription, EnumSet.of(OperationEntry.Flag.RESTART_ALL_SERVICES));
        DefaultResourceRemoveDescriptionProvider subsystemRemoveDescription = new DefaultResourceRemoveDescriptionProvider(rootResolver);
        rootResourceRegistration.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, (DescriptionProvider)subsystemRemoveDescription, EnumSet.of(OperationEntry.Flag.RESTART_ALL_SERVICES));
    }

    public void registerAttributes(ManagementResourceRegistration rootResourceRegistration) {
        JAXRWriteAttributeHandler writeHandler = new JAXRWriteAttributeHandler(this.config);
        writeHandler.registerAttributes(rootResourceRegistration);
    }
}

