/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.service;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.jboss.as.jpa.JpaLogger;
import org.jboss.as.jpa.classloader.TempClassLoaderFactoryImpl;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.as.jpa.spi.PersistenceUnitService;
import org.jboss.as.jpa.spi.TempClassLoaderFactory;
import org.jboss.as.jpa.util.JPAServiceNames;
import org.jboss.as.naming.WritableServiceBasedNamingStore;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class PersistenceUnitServiceImpl
implements Service<PersistenceUnitServiceImpl>,
PersistenceUnitService {
    private final InjectedValue<Map> properties = new InjectedValue();
    private final InjectedValue<DataSource> jtaDataSource = new InjectedValue();
    private final InjectedValue<DataSource> nonJtaDataSource = new InjectedValue();
    private final PersistenceProviderAdaptor persistenceProviderAdaptor;
    private final PersistenceProvider persistenceProvider;
    private final PersistenceUnitMetadata pu;
    private final ClassLoader classLoader;
    private volatile EntityManagerFactory entityManagerFactory;

    public PersistenceUnitServiceImpl(ClassLoader classLoader, PersistenceUnitMetadata pu, PersistenceProviderAdaptor persistenceProviderAdaptor, PersistenceProvider persistenceProvider) {
        this.pu = pu;
        this.persistenceProviderAdaptor = persistenceProviderAdaptor;
        this.persistenceProvider = persistenceProvider;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        try {
            JpaLogger.JPA_LOGGER.startingService("Persistence Unit", this.pu.getScopedPersistenceUnitName());
            this.pu.setTempClassLoaderFactory((TempClassLoaderFactory)new TempClassLoaderFactoryImpl(this.classLoader));
            this.pu.setJtaDataSource((DataSource)this.jtaDataSource.getOptionalValue());
            this.pu.setNonJtaDataSource((DataSource)this.nonJtaDataSource.getOptionalValue());
            WritableServiceBasedNamingStore.pushOwner((ServiceTarget)context.getController().getServiceContainer().subTarget(), (ServiceName[])new ServiceName[0]);
            this.entityManagerFactory = this.createContainerEntityManagerFactory();
        }
        finally {
            this.pu.setTempClassLoaderFactory(null);
            WritableServiceBasedNamingStore.popOwner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        JpaLogger.JPA_LOGGER.stoppingService("Persistence Unit", this.pu.getScopedPersistenceUnitName());
        if (this.entityManagerFactory != null) {
            WritableServiceBasedNamingStore.pushOwner((ServiceTarget)context.getController().getServiceContainer().subTarget(), (ServiceName[])new ServiceName[0]);
            try {
                this.entityManagerFactory.close();
            }
            finally {
                this.entityManagerFactory = null;
                this.pu.setTempClassLoaderFactory(null);
                WritableServiceBasedNamingStore.popOwner();
            }
        }
    }

    public PersistenceUnitServiceImpl getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public String getScopedPersistenceUnitName() {
        return this.pu.getScopedPersistenceUnitName();
    }

    public Injector<Map> getPropertiesInjector() {
        return this.properties;
    }

    public Injector<DataSource> getJtaDataSourceInjector() {
        return this.jtaDataSource;
    }

    public Injector<DataSource> getNonJtaDataSourceInjector() {
        return this.nonJtaDataSource;
    }

    public static ServiceName getPUServiceName(PersistenceUnitMetadata pu) {
        return JPAServiceNames.getPUServiceName((String)pu.getScopedPersistenceUnitName());
    }

    public static ServiceName getPUServiceName(String scopedPersistenceUnitName) {
        return JPAServiceNames.getPUServiceName((String)scopedPersistenceUnitName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManagerFactory createContainerEntityManagerFactory() {
        this.persistenceProviderAdaptor.beforeCreateContainerEntityManagerFactory(this.pu);
        try {
            EntityManagerFactory entityManagerFactory = this.persistenceProvider.createContainerEntityManagerFactory((PersistenceUnitInfo)this.pu, (Map)this.properties.getValue());
            return entityManagerFactory;
        }
        finally {
            try {
                this.persistenceProviderAdaptor.afterCreateContainerEntityManagerFactory(this.pu);
            }
            finally {
                this.pu.setAnnotationIndex(null);
            }
        }
    }
}

