/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.modcluster.Element;
import org.jboss.as.modcluster.ModClusterConfigResourceDefinition;
import org.jboss.as.modcluster.ModClusterSSLResourceDefinition;
import org.jboss.as.modcluster.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class ModClusterSubsystemXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode node = context.getModelNode();
        if (node.get("mod-cluster-config").isDefined() && node.get("mod-cluster-config").has("configuration")) {
            ModClusterSubsystemXMLWriter.writeModClusterConfig(writer, node.get("mod-cluster-config").get("configuration"));
        } else {
            ModClusterSubsystemXMLWriter.writeModClusterConfig(writer, node);
        }
        writer.writeEndElement();
    }

    static void writeModClusterConfig(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        writer.writeStartElement(Element.MOD_CLUSTER_CONFIG.getLocalName());
        ModClusterSubsystemXMLWriter.writePropConf(writer, config);
        if (config.hasDefined("simple-load-provider")) {
            ModClusterSubsystemXMLWriter.writeSimpleLoadProvider(writer, config.get("simple-load-provider"));
        }
        if (config.hasDefined("dynamic-load-provider")) {
            ModClusterSubsystemXMLWriter.writeDynamicLoadProvider(writer, config.get("dynamic-load-provider"));
        }
        if (config.get("ssl").isDefined() && config.get("ssl").has("configuration")) {
            ModClusterSubsystemXMLWriter.writeSSL(writer, config.get("ssl").get("configuration"));
        }
        writer.writeEndElement();
    }

    static void writePropConf(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        ModClusterConfigResourceDefinition.ADVERTISE_SOCKET.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.PROXY_LIST.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.PROXY_URL.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.BALANCER.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.DOMAIN.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.ADVERTISE.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.ADVERTISE_SECURITY_KEY.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.EXCLUDED_CONTEXTS.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.AUTO_ENABLE_CONTEXTS.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.STOP_CONTEXT_TIMEOUT.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.SOCKET_TIMEOUT.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.STICKY_SESSION.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.STICKY_SESSION_REMOVE.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.STICKY_SESSION_FORCE.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.WORKER_TIMEOUT.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.MAX_ATTEMPTS.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.FLUSH_PACKETS.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.FLUSH_WAIT.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.PING.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.SMAX.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.TTL.marshallAsAttribute(config, (XMLStreamWriter)writer);
        ModClusterConfigResourceDefinition.NODE_TIMEOUT.marshallAsAttribute(config, (XMLStreamWriter)writer);
    }

    static void writeSSL(XMLExtendedStreamWriter writer, ModelNode sslConfig) throws XMLStreamException {
        writer.writeStartElement(Element.SSL.getLocalName());
        ModClusterSSLResourceDefinition.KEY_ALIAS.marshallAsAttribute(sslConfig, (XMLStreamWriter)writer);
        ModClusterSSLResourceDefinition.PASSWORD.marshallAsAttribute(sslConfig, (XMLStreamWriter)writer);
        ModClusterSSLResourceDefinition.CERTIFICATE_KEY_FILE.marshallAsAttribute(sslConfig, (XMLStreamWriter)writer);
        ModClusterSSLResourceDefinition.CIPHER_SUITE.marshallAsAttribute(sslConfig, (XMLStreamWriter)writer);
        ModClusterSSLResourceDefinition.PROTOCOL.marshallAsAttribute(sslConfig, (XMLStreamWriter)writer);
        ModClusterSSLResourceDefinition.CA_CERTIFICATE_FILE.marshallAsAttribute(sslConfig, (XMLStreamWriter)writer);
        ModClusterSSLResourceDefinition.CA_REVOCATION_URL.marshallAsAttribute(sslConfig, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    static void writeSimpleLoadProvider(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        writer.writeStartElement(Element.SIMPLE_LOAD_PROVIDER.getLocalName());
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "factor", config);
        writer.writeEndElement();
    }

    static void writeDynamicLoadProvider(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        writer.writeStartElement(Element.DYNAMIC_LOAD_PROVIDER.getLocalName());
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "history", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "decay", config);
        if (config.hasDefined("load-metric")) {
            ModClusterSubsystemXMLWriter.writeLoadMetric(writer, config.get("load-metric"));
        }
        if (config.hasDefined("custom-load-metric")) {
            ModClusterSubsystemXMLWriter.writeCustomLoadMetric(writer, config.get("custom-load-metric"));
        }
        writer.writeEndElement();
    }

    static void writeLoadMetric(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        for (ModelNode node : config.asList()) {
            writer.writeStartElement(Element.LOAD_METRIC.getLocalName());
            ModClusterSubsystemXMLWriter.writeAttribute(writer, "type", node);
            ModClusterSubsystemXMLWriter.writeAttribute(writer, "weight", node);
            ModClusterSubsystemXMLWriter.writeAttribute(writer, "capacity", node);
            if (node.get("property").isDefined()) {
                for (Property property : node.get("property").asPropertyList()) {
                    ModClusterSubsystemXMLWriter.writeProperty(writer, property);
                }
            }
            writer.writeEndElement();
        }
    }

    static void writeCustomLoadMetric(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        for (ModelNode node : config.asList()) {
            writer.writeStartElement(Element.CUSTOM_LOAD_METRIC.getLocalName());
            ModClusterSubsystemXMLWriter.writeAttribute(writer, "capacity", node);
            ModClusterSubsystemXMLWriter.writeAttribute(writer, "weight", node);
            ModClusterSubsystemXMLWriter.writeAttribute(writer, "class", node);
            if (node.get("property").isDefined()) {
                for (Property property : node.get("property").asPropertyList()) {
                    ModClusterSubsystemXMLWriter.writeProperty(writer, property);
                }
            }
            writer.writeEndElement();
        }
    }

    static void writeAttribute(XMLExtendedStreamWriter writer, String name, ModelNode node) throws XMLStreamException {
        if (node.hasDefined(name)) {
            writer.writeAttribute(name, node.get(name).asString());
        }
    }

    static void writeProperty(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeStartElement(Element.PROPERTY.getLocalName());
        writer.writeAttribute("name", property.getName());
        writer.writeAttribute("value", property.getValue().asString());
        writer.writeEndElement();
    }
}

