/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.internal.antlr.SqlGeneratorBase;
import org.hibernate.hql.internal.antlr.SqlTokenTypes;
import org.hibernate.hql.internal.ast.ErrorCounter;
import org.hibernate.hql.internal.ast.ErrorReporter;
import org.hibernate.hql.internal.ast.ParseErrorHandler;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.FunctionNode;
import org.hibernate.hql.internal.ast.tree.Node;
import org.hibernate.hql.internal.ast.tree.ParameterContainer;
import org.hibernate.hql.internal.ast.tree.ParameterNode;
import org.hibernate.hql.internal.ast.util.ASTPrinter;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class SqlGenerator
extends SqlGeneratorBase
implements ErrorReporter {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)SqlGenerator.class.getName());
    public static boolean REGRESSION_STYLE_CROSS_JOINS = false;
    private SqlWriter writer = new DefaultWriter();
    private ParseErrorHandler parseErrorHandler;
    private SessionFactoryImplementor sessionFactory;
    private LinkedList<SqlWriter> outputStack = new LinkedList();
    private final ASTPrinter printer = new ASTPrinter(SqlTokenTypes.class);
    private List collectedParameters = new ArrayList();
    private int traceDepth = 0;

    public void traceIn(String ruleName, AST tree) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        if (this.inputState.guessing > 0) {
            return;
        }
        String prefix = StringHelper.repeat('-', this.traceDepth++ * 2) + "-> ";
        String traceText = ruleName + " (" + this.buildTraceNodeName(tree) + ")";
        LOG.trace(prefix + traceText);
    }

    private String buildTraceNodeName(AST tree) {
        return tree == null ? "???" : tree.getText() + " [" + this.printer.getTokenTypeName(tree.getType()) + "]";
    }

    public void traceOut(String ruleName, AST tree) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        if (this.inputState.guessing > 0) {
            return;
        }
        String prefix = "<-" + StringHelper.repeat('-', --this.traceDepth * 2) + " ";
        LOG.trace(prefix + ruleName);
    }

    public List getCollectedParameters() {
        return this.collectedParameters;
    }

    @Override
    protected void out(String s) {
        this.writer.clause(s);
    }

    @Override
    protected void out(AST n) {
        ParameterSpecification[] specifications;
        if (n instanceof Node) {
            this.out(((Node)n).getRenderText(this.sessionFactory));
        } else {
            super.out(n);
        }
        if (n instanceof ParameterNode) {
            this.collectedParameters.add(((ParameterNode)n).getHqlParameterSpecification());
        } else if (n instanceof ParameterContainer && ((ParameterContainer)n).hasEmbeddedParameters() && (specifications = ((ParameterContainer)n).getEmbeddedParameters()) != null) {
            this.collectedParameters.addAll(Arrays.asList(specifications));
        }
    }

    @Override
    protected void commaBetweenParameters(String comma) {
        this.writer.commaBetweenParameters(comma);
    }

    @Override
    public void reportError(RecognitionException e) {
        this.parseErrorHandler.reportError(e);
    }

    @Override
    public void reportError(String s) {
        this.parseErrorHandler.reportError(s);
    }

    @Override
    public void reportWarning(String s) {
        this.parseErrorHandler.reportWarning(s);
    }

    public ParseErrorHandler getParseErrorHandler() {
        return this.parseErrorHandler;
    }

    public SqlGenerator(SessionFactoryImplementor sfi) {
        this.parseErrorHandler = new ErrorCounter();
        this.sessionFactory = sfi;
    }

    public String getSQL() {
        return this.getStringBuffer().toString();
    }

    @Override
    protected void optionalSpace() {
        int c = this.getLastChar();
        switch (c) {
            case -1: {
                return;
            }
            case 32: {
                return;
            }
            case 41: {
                return;
            }
            case 40: {
                return;
            }
        }
        this.out(" ");
    }

    @Override
    protected void beginFunctionTemplate(AST node, AST nameNode) {
        FunctionNode functionNode = (FunctionNode)node;
        SQLFunction sqlFunction = functionNode.getSQLFunction();
        if (sqlFunction == null) {
            super.beginFunctionTemplate(node, nameNode);
        } else {
            this.outputStack.addFirst(this.writer);
            this.writer = new FunctionArguments();
        }
    }

    @Override
    protected void endFunctionTemplate(AST node) {
        FunctionNode functionNode = (FunctionNode)node;
        SQLFunction sqlFunction = functionNode.getSQLFunction();
        if (sqlFunction == null) {
            super.endFunctionTemplate(node);
        } else {
            Type functionType = functionNode.getFirstArgumentType();
            FunctionArguments functionArguments = (FunctionArguments)this.writer;
            this.writer = this.outputStack.removeFirst();
            this.out(sqlFunction.render(functionType, functionArguments.getArgs(), this.sessionFactory));
        }
    }

    public static void panic() {
        throw new QueryException("TreeWalker: panic");
    }

    @Override
    protected void fromFragmentSeparator(AST a) {
        FromElement right;
        AST next = a.getNextSibling();
        if (next == null || !this.hasText(a)) {
            return;
        }
        FromElement left = (FromElement)a;
        for (right = (FromElement)next; right != null && !this.hasText((AST)right); right = (FromElement)right.getNextSibling()) {
        }
        if (right == null) {
            return;
        }
        if (!this.hasText((AST)right)) {
            return;
        }
        if (right.getRealOrigin() == left || right.getRealOrigin() != null && right.getRealOrigin() == left.getRealOrigin()) {
            if (right.getJoinSequence() != null && right.getJoinSequence().isThetaStyle()) {
                this.writeCrossJoinSeparator();
            } else {
                this.out(" ");
            }
        } else {
            this.writeCrossJoinSeparator();
        }
    }

    private void writeCrossJoinSeparator() {
        if (REGRESSION_STYLE_CROSS_JOINS) {
            this.out(", ");
        } else {
            this.out(this.sessionFactory.getDialect().getCrossJoinSeparator());
        }
    }

    @Override
    protected void nestedFromFragment(AST d, AST parent) {
        if (d != null && this.hasText(d)) {
            if (parent != null && this.hasText(parent)) {
                FromElement left = (FromElement)parent;
                FromElement right = (FromElement)d;
                if (right.getRealOrigin() == left) {
                    if (right.getJoinSequence() != null && right.getJoinSequence().isThetaStyle()) {
                        this.out(", ");
                    } else {
                        this.out(" ");
                    }
                } else {
                    this.out(", ");
                }
            }
            this.out(d);
        }
    }

    class DefaultWriter
    implements SqlWriter {
        DefaultWriter() {
        }

        @Override
        public void clause(String clause) {
            SqlGenerator.this.getStringBuffer().append(clause);
        }

        @Override
        public void commaBetweenParameters(String comma) {
            SqlGenerator.this.getStringBuffer().append(comma);
        }
    }

    class FunctionArguments
    implements SqlWriter {
        private int argInd;
        private final List<String> args = new ArrayList<String>(3);

        FunctionArguments() {
        }

        @Override
        public void clause(String clause) {
            if (this.argInd == this.args.size()) {
                this.args.add(clause);
            } else {
                this.args.set(this.argInd, this.args.get(this.argInd) + clause);
            }
        }

        @Override
        public void commaBetweenParameters(String comma) {
            ++this.argInd;
        }

        public List getArgs() {
            return this.args;
        }
    }

    static interface SqlWriter {
        public void clause(String var1);

        public void commaBetweenParameters(String var1);
    }
}

