/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.subsystem;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.cmp.subsystem.CmpConstants;
import org.jboss.as.cmp.subsystem.Namespace;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class CmpSubsystemDescriptions {
    static final String RESOURCE_NAME = CmpSubsystemDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    static final ModelNode getSubystemDescription(Locale locale) {
        ResourceBundle bundle2 = CmpSubsystemDescriptions.getResourceBundle(locale);
        ModelNode subsystem = new ModelNode();
        subsystem.get("description").set(bundle2.getString("cmp"));
        subsystem.get("head-comment-allowed").set(true);
        subsystem.get("tail-comment-allowed").set(true);
        subsystem.get("namespace").set(Namespace.CMP_1_0.getUriString());
        subsystem.get(new String[]{"children", CmpConstants.UUID_KEY_GENERATOR, "description"}).set(bundle2.getString("uuid-key-generator"));
        subsystem.get(new String[]{"children", CmpConstants.UUID_KEY_GENERATOR, "min-occurs"}).set(0);
        subsystem.get(new String[]{"children", CmpConstants.UUID_KEY_GENERATOR, "max-occurs"}).set(Integer.MAX_VALUE);
        subsystem.get(new String[]{"children", CmpConstants.HILO_KEY_GENERATOR, "description"}).set(bundle2.getString("hilo-key-generator"));
        subsystem.get(new String[]{"children", CmpConstants.HILO_KEY_GENERATOR, "min-occurs"}).set(0);
        subsystem.get(new String[]{"children", CmpConstants.HILO_KEY_GENERATOR, "max-occurs"}).set(Integer.MAX_VALUE);
        subsystem.get("operations");
        return subsystem;
    }

    static ModelNode getSubsystemRemoveDescription(Locale locale) {
        ResourceBundle bundle2 = CmpSubsystemDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle2.getString("cmp.remove"));
        op.get("reply-properties").setEmptyObject();
        op.get("request-properties").setEmptyObject();
        return op;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    public static ModelNode getSubystemAddDescription(Locale locale) {
        ResourceBundle bundle2 = CmpSubsystemDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("cmp.add"));
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    public static ModelNode getHiLoKeyGeneratorDescription(Locale locale) {
        ResourceBundle bundle2 = CmpSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("hilo-key-generator"));
        node.get("head-comment-allowed").set(true);
        node.get("tail-comment-allowed").set(true);
        for (AttributeDefinition attr : HiLoAttributeDefinitions.HILO_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle2, "hilo-key-generator", node);
        }
        return node;
    }

    public static ModelNode getUuidKeyGeneratorDescription(Locale locale) {
        ResourceBundle bundle2 = CmpSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("uuid-key-generator"));
        node.get("head-comment-allowed").set(true);
        node.get("tail-comment-allowed").set(true);
        return node;
    }

    public static ModelNode getHiLoAddDescription(Locale locale) {
        ResourceBundle bundle2 = CmpSubsystemDescriptions.getResourceBundle(locale);
        ModelNode operation = new ModelNode();
        operation.get("operation-name").set("add");
        operation.get("description").set("hilo-key-generator.add");
        for (AttributeDefinition attr : HiLoAttributeDefinitions.HILO_ATTRIBUTES) {
            operation.get(new String[]{"request-properties", attr.getName(), "description"}).set(bundle2.getString("hilo-key-generator." + attr.getName()));
            operation.get(new String[]{"request-properties", attr.getName(), "type"}).set(attr.getType());
            operation.get(new String[]{"request-properties", attr.getName(), "required"}).set(false);
        }
        return operation;
    }

    public static ModelNode getHiLoRemoveDescription(Locale locale) {
        ResourceBundle bundle2 = CmpSubsystemDescriptions.getResourceBundle(locale);
        ModelNode operation = new ModelNode();
        operation.get("operation-name").set("remove");
        operation.get("description").set("hilo-key-generator.remove");
        return operation;
    }

    public static ModelNode getUuidAddDescription(Locale locale) {
        ResourceBundle bundle2 = CmpSubsystemDescriptions.getResourceBundle(locale);
        ModelNode operation = new ModelNode();
        operation.get("operation-name").set("add");
        operation.get("description").set("uuid-key-generator.add");
        return operation;
    }

    public static ModelNode getUuidRemoveDescription(Locale locale) {
        ResourceBundle bundle2 = CmpSubsystemDescriptions.getResourceBundle(locale);
        ModelNode operation = new ModelNode();
        operation.get("operation-name").set("remove");
        operation.get("description").set("uuid-key-generator.remove");
        return operation;
    }

    private static interface HiLoAttributeDefinitions {
        public static final SimpleAttributeDefinition BLOCK_SIZE = new SimpleAttributeDefinition(CmpConstants.BLOCK_SIZE, ModelType.LONG, true);
        public static final SimpleAttributeDefinition CREATE_TABLE = new SimpleAttributeDefinition(CmpConstants.CREATE_TABLE, ModelType.BOOLEAN, true);
        public static final SimpleAttributeDefinition CREATE_TABLE_DDL = new SimpleAttributeDefinition(CmpConstants.CREATE_TABLE_DDL, ModelType.STRING, true);
        public static final SimpleAttributeDefinition DATA_SOURCE = new SimpleAttributeDefinition(CmpConstants.DATA_SOURCE, ModelType.STRING, true);
        public static final SimpleAttributeDefinition DROP_TABLE = new SimpleAttributeDefinition(CmpConstants.DROP_TABLE, ModelType.BOOLEAN, true);
        public static final SimpleAttributeDefinition ID_COLUMN = new SimpleAttributeDefinition(CmpConstants.ID_COLUMN, ModelType.STRING, true);
        public static final SimpleAttributeDefinition SELECT_HI_DDL = new SimpleAttributeDefinition(CmpConstants.SELECT_HI_DDL, ModelType.STRING, true);
        public static final SimpleAttributeDefinition SEQUENCE_COLUMN = new SimpleAttributeDefinition(CmpConstants.SEQUENCE_COLUMN, ModelType.STRING, true);
        public static final SimpleAttributeDefinition SEQUENCE_NAME = new SimpleAttributeDefinition(CmpConstants.SEQUENCE_NAME, ModelType.STRING, true);
        public static final SimpleAttributeDefinition TABLE_NAME = new SimpleAttributeDefinition(CmpConstants.TABLE_NAME, ModelType.STRING, true);
        public static final AttributeDefinition[] HILO_ATTRIBUTES = new AttributeDefinition[]{BLOCK_SIZE, CREATE_TABLE, CREATE_TABLE_DDL, DATA_SOURCE, DROP_TABLE, ID_COLUMN, SELECT_HI_DDL, SEQUENCE_COLUMN, SEQUENCE_NAME, TABLE_NAME};
    }
}

